% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchDB.R
\name{searchDB}
\alias{searchDB}
\title{Search in customized database}
\usage{
searchDB(DF, DB, ppm = 5, RT = 0.2, useRT = FALSE)
}
\arguments{
\item{DF}{input file, should contain at least a column named mz}

\item{DB}{database, should contain at least a column named mz}

\item{ppm}{mass tolerance, default 5ppm}

\item{RT}{retention time tolerance, default 0.2min}

\item{useRT}{should RT be considered during database search?}
}
\description{
search in customized database based on accurate m/z and RT
}
\examples{
DF <- cbind.data.frame(mz = c(100.001, 100.1), RT = c(10, 11))
DB <- cbind.data.frame(mz = c(100.001, 100.1), RT = c(10, 12.1))
searchDB(DF, DB, ppm = 5, RT = 0.2, useRT = TRUE)
}
\author{
Yonghui Dong
}
