#include "SingleRegime.h"
#include "tGARCH.h"
#include "Normal.h"
#include "Ged.h"
#include "Student.h"
#include "Symmetric.h"
#include "Skewed.h"
//============================================================================//
//============================================================================//
//================================== tGARCH ==================================//
//============================================================================//
//============================================================================//

typedef SingleRegime<tGARCH<Symmetric<Normal> > > tGARCH_norm;
typedef SingleRegime<tGARCH<Skewed<Normal> > > tGARCH_snorm;
typedef SingleRegime<tGARCH<Symmetric<Student> > > tGARCH_std;
typedef SingleRegime<tGARCH<Skewed<Student> > > tGARCH_sstd;
typedef SingleRegime<tGARCH<Symmetric<Ged> > > tGARCH_ged;
typedef SingleRegime<tGARCH<Skewed<Ged> > > tGARCH_sged;

RCPP_MODULE(tGARCH) {
  // tGARCH-norm-symmetric
  class_<tGARCH_norm>("tGARCH_norm")
      .constructor()
      .field("name", &tGARCH_norm::name)
      .field("theta0", &tGARCH_norm::theta0)
      .field("Sigma0", &tGARCH_norm::Sigma0)
      .field("label", &tGARCH_norm::label)
      .field("lower", &tGARCH_norm::lower)
      .field("upper", &tGARCH_norm::upper)
      .field("ineq_lb", &tGARCH_norm::ineq_lb)
      .field("ineq_ub", &tGARCH_norm::ineq_ub)
      .field("NbParams", &tGARCH_norm::NbParams)
      .field("NbParamsModel", &tGARCH_norm::NbParamsModel)
      .method("f_sim", &tGARCH_norm::f_sim)
      .method("f_pdf", &tGARCH_norm::f_pdf)
      .method("f_pdf_its", &tGARCH_norm::f_pdf_its)
      .method("f_cdf", &tGARCH_norm::f_cdf)
      .method("f_cdf_its", &tGARCH_norm::f_cdf_its)
      .method("f_simAhead", &tGARCH_norm::f_simAhead)
      .method("f_get_sd", &tGARCH_norm::get_sd)
      .method("f_set_sd", &tGARCH_norm::set_sd)
      .method("f_get_mean", &tGARCH_norm::get_mean)
      .method("f_set_mean", &tGARCH_norm::set_mean)
      .method("f_rnd", &tGARCH_norm::f_rnd)
      .method("calc_ht", &tGARCH_norm::calc_ht)
      .method("eval_model", &tGARCH_norm::eval_model)
      .method("ineq_func", &tGARCH_norm::ineq_func)
      .method("f_unc_vol", &tGARCH_norm::f_unc_vol);
  // tGARCH-std-symmetric
  class_<tGARCH_std>("tGARCH_std")
      .constructor()
      .field("name", &tGARCH_std::name)
      .field("theta0", &tGARCH_std::theta0)
      .field("Sigma0", &tGARCH_std::Sigma0)
      .field("label", &tGARCH_std::label)
      .field("lower", &tGARCH_std::lower)
      .field("upper", &tGARCH_std::upper)
      .field("ineq_lb", &tGARCH_std::ineq_lb)
      .field("ineq_ub", &tGARCH_std::ineq_ub)
      .field("NbParams", &tGARCH_std::NbParams)
      .field("NbParamsModel", &tGARCH_std::NbParamsModel)
      .method("f_sim", &tGARCH_std::f_sim)
      .method("f_pdf", &tGARCH_std::f_pdf)
      .method("f_pdf_its", &tGARCH_std::f_pdf_its)
      .method("f_cdf", &tGARCH_std::f_cdf)
      .method("f_cdf_its", &tGARCH_std::f_cdf_its)
      .method("f_simAhead", &tGARCH_std::f_simAhead)
      .method("f_get_sd", &tGARCH_std::get_sd)
      .method("f_set_sd", &tGARCH_std::set_sd)
      .method("f_get_mean", &tGARCH_std::get_mean)
      .method("f_set_mean", &tGARCH_std::set_mean)
      .method("f_rnd", &tGARCH_std::f_rnd)
      .method("calc_ht", &tGARCH_std::calc_ht)
      .method("eval_model", &tGARCH_std::eval_model)
      .method("ineq_func", &tGARCH_std::ineq_func)
      .method("f_unc_vol", &tGARCH_std::f_unc_vol);
  // tGARCH-ged-symmetric
  class_<tGARCH_ged>("tGARCH_ged")
      .constructor()
      .field("name", &tGARCH_ged::name)
      .field("theta0", &tGARCH_ged::theta0)
      .field("Sigma0", &tGARCH_ged::Sigma0)
      .field("label", &tGARCH_ged::label)
      .field("lower", &tGARCH_ged::lower)
      .field("upper", &tGARCH_ged::upper)
      .field("ineq_lb", &tGARCH_ged::ineq_lb)
      .field("ineq_ub", &tGARCH_ged::ineq_ub)
      .field("NbParams", &tGARCH_ged::NbParams)
      .field("NbParamsModel", &tGARCH_ged::NbParamsModel)
      .method("f_sim", &tGARCH_ged::f_sim)
      .method("f_pdf", &tGARCH_ged::f_pdf)
      .method("f_pdf_its", &tGARCH_ged::f_pdf_its)
      .method("f_cdf", &tGARCH_ged::f_cdf)
      .method("f_cdf_its", &tGARCH_ged::f_cdf_its)
      .method("f_simAhead", &tGARCH_ged::f_simAhead)
      .method("f_get_sd", &tGARCH_ged::get_sd)
      .method("f_set_sd", &tGARCH_ged::set_sd)
      .method("f_get_mean", &tGARCH_ged::get_mean)
      .method("f_set_mean", &tGARCH_ged::set_mean)
      .method("f_rnd", &tGARCH_ged::f_rnd)
      .method("calc_ht", &tGARCH_ged::calc_ht)
      .method("eval_model", &tGARCH_ged::eval_model)
      .method("ineq_func", &tGARCH_ged::ineq_func)
      .method("f_unc_vol", &tGARCH_ged::f_unc_vol);

  // tGARCH-norm-skew
  class_<tGARCH_snorm>("tGARCH_snorm")
      .constructor()
      .field("name", &tGARCH_snorm::name)
      .field("theta0", &tGARCH_snorm::theta0)
      .field("Sigma0", &tGARCH_snorm::Sigma0)
      .field("label", &tGARCH_snorm::label)
      .field("lower", &tGARCH_snorm::lower)
      .field("upper", &tGARCH_snorm::upper)
      .field("ineq_lb", &tGARCH_snorm::ineq_lb)
      .field("ineq_ub", &tGARCH_snorm::ineq_ub)
      .field("NbParams", &tGARCH_snorm::NbParams)
      .field("NbParamsModel", &tGARCH_snorm::NbParamsModel)
      .method("f_sim", &tGARCH_snorm::f_sim)
      .method("f_pdf", &tGARCH_snorm::f_pdf)
      .method("f_pdf_its", &tGARCH_snorm::f_pdf_its)
      .method("f_cdf", &tGARCH_snorm::f_cdf)
      .method("f_cdf_its", &tGARCH_snorm::f_cdf_its)
      .method("f_simAhead", &tGARCH_snorm::f_simAhead)
      .method("f_get_sd", &tGARCH_snorm::get_sd)
      .method("f_set_sd", &tGARCH_snorm::set_sd)
      .method("f_get_mean", &tGARCH_snorm::get_mean)
      .method("f_set_mean", &tGARCH_snorm::set_mean)
      .method("f_rnd", &tGARCH_snorm::f_rnd)
      .method("calc_ht", &tGARCH_snorm::calc_ht)
      .method("eval_model", &tGARCH_snorm::eval_model)
      .method("ineq_func", &tGARCH_snorm::ineq_func)
      .method("f_unc_vol", &tGARCH_snorm::f_unc_vol);
  // tGARCH-std-skew
  class_<tGARCH_sstd>("tGARCH_sstd")
      .constructor()
      .field("name", &tGARCH_sstd::name)
      .field("theta0", &tGARCH_sstd::theta0)
      .field("Sigma0", &tGARCH_sstd::Sigma0)
      .field("label", &tGARCH_sstd::label)
      .field("lower", &tGARCH_sstd::lower)
      .field("upper", &tGARCH_sstd::upper)
      .field("ineq_lb", &tGARCH_sstd::ineq_lb)
      .field("ineq_ub", &tGARCH_sstd::ineq_ub)
      .field("NbParams", &tGARCH_sstd::NbParams)
      .field("NbParamsModel", &tGARCH_sstd::NbParamsModel)
      .method("f_sim", &tGARCH_sstd::f_sim)
      .method("f_pdf", &tGARCH_sstd::f_pdf)
      .method("f_pdf_its", &tGARCH_sstd::f_pdf_its)
      .method("f_cdf", &tGARCH_sstd::f_cdf)
      .method("f_cdf_its", &tGARCH_sstd::f_cdf_its)
      .method("f_simAhead", &tGARCH_sstd::f_simAhead)
      .method("f_get_sd", &tGARCH_sstd::get_sd)
      .method("f_set_sd", &tGARCH_sstd::set_sd)
      .method("f_get_mean", &tGARCH_sstd::get_mean)
      .method("f_set_mean", &tGARCH_sstd::set_mean)
      .method("f_rnd", &tGARCH_sstd::f_rnd)
      .method("calc_ht", &tGARCH_sstd::calc_ht)
      .method("eval_model", &tGARCH_sstd::eval_model)
      .method("ineq_func", &tGARCH_sstd::ineq_func)
      .method("f_unc_vol", &tGARCH_sstd::f_unc_vol);
  // tGARCH-ged-skew
  class_<tGARCH_sged>("tGARCH_sged")
      .constructor()
      .field("name", &tGARCH_sged::name)
      .field("theta0", &tGARCH_sged::theta0)
      .field("Sigma0", &tGARCH_sged::Sigma0)
      .field("label", &tGARCH_sged::label)
      .field("lower", &tGARCH_sged::lower)
      .field("upper", &tGARCH_sged::upper)
      .field("ineq_lb", &tGARCH_sged::ineq_lb)
      .field("ineq_ub", &tGARCH_sged::ineq_ub)
      .field("NbParams", &tGARCH_sged::NbParams)
      .field("NbParamsModel", &tGARCH_sged::NbParamsModel)
      .method("f_sim", &tGARCH_sged::f_sim)
      .method("f_pdf", &tGARCH_sged::f_pdf)
      .method("f_pdf_its", &tGARCH_sged::f_pdf_its)
      .method("f_cdf", &tGARCH_sged::f_cdf)
      .method("f_cdf_its", &tGARCH_sged::f_cdf_its)
      .method("f_simAhead", &tGARCH_sged::f_simAhead)
      .method("f_get_sd", &tGARCH_sged::get_sd)
      .method("f_set_sd", &tGARCH_sged::set_sd)
      .method("f_get_mean", &tGARCH_sged::get_mean)
      .method("f_set_mean", &tGARCH_sged::set_mean)
      .method("f_rnd", &tGARCH_sged::f_rnd)
      .method("calc_ht", &tGARCH_sged::calc_ht)
      .method("eval_model", &tGARCH_sged::eval_model)
      .method("ineq_func", &tGARCH_sged::ineq_func)
      .method("f_unc_vol", &tGARCH_sged::f_unc_vol);
}
