% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/State.R
\name{State}
\alias{State}
\alias{State.MSGARCH_SPEC}
\alias{State.MSGARCH_ML_FIT}
\alias{State.MSGARCH_MCMC_FIT}
\title{State probabilities.}
\usage{
State(object, ...)

\method{State}{MSGARCH_SPEC}(object, par, data, ...)

\method{State}{MSGARCH_ML_FIT}(object, new.data = NULL, ...)

\method{State}{MSGARCH_MCMC_FIT}(object, new.data = NULL, ...)
}
\arguments{
\item{object}{Model specification of class \code{MSGARCH_SPEC}
created with \code{\link{CreateSpec}} or fit object of type \code{MSGARCH_ML_FIT}
created with \code{\link{FitML}} or \code{MSGARCH_MCMC_FIT}
created with \code{\link{FitMCMC}}.}

\item{...}{Not used. Other arguments to \code{State}.}

\item{par}{Vector (of size d) or matrix (of size \code{n.mcmc} x d) of parameter estimates
where d must have
the same length as the default parameters of the specification.}

\item{data}{Vector (of size T) of observations.}

\item{new.data}{Vector (of size T*) of new observations. (Default \code{new.data = NULL})}
}
\value{
A list of class \code{MSGARCH_PSTATE} with the following elements:
\itemize{
\item \code{FiltProb}: Filtered probabilities (array of size (T + T*) x (\code{n.mcmc or 1}) x K).
\item \code{PredProb}: Predictive probabilities (array of size (T + T* + 1) x (\code{n.mcmc or 1}) x K).
\item \code{SmoothProb}: Smoothed probabilities (array of size (T + T* + 1) x (\code{n.mcmc or 1}) x K).
\item \code{Viterbi}:  Most likely path (matrix of size (T + T*) x (\code{n.mcmc} or 1)).
}
The class \code{MSGARCH_PSTATE} contains the \code{plot} method. The plot method contains
as input \code{type.prob} which is one of \code{"filtered", "predictive", "smoothed", "viterbi"}.
(Default: \code{type.prob = "smoothed"})
}
\description{
Method returning the filtered, predictive, smoothed probabilities of the states,
and the most probable path computed with the Viterbi alogirthm.
}
\details{
If a matrix of parameter estimates is given, each parameter
estimate (each row) is evaluated individually.
}
\examples{
# load data
data("SMI", package = "MSGARCH")

# create model specification
# MS(2)-GARCH(1,1)-Normal (default)
spec <- CreateSpec()

# fit the model on the data with ML estimation
fit <- FitML(spec = spec, data = SMI)

# compute the filtered state probabilities
state <- State(object = fit)
plot(state, type.prob = "smoothed")
plot(state, type.prob = "predictive")
plot(state, type.prob = "filtered")
plot(state, type.prob = "viterbi")
}
