% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unc.vol.R
\name{unc.vol}
\alias{unc.vol}
\title{Unconditional volatility of each regime.}
\usage{
unc.vol(object, theta)
}
\arguments{
\item{object}{Model specification of class \code{MSGARCH_SPEC} created with \code{\link{create.spec}}
or fit object of type \code{MSGARCH_MLE_FIT} created with \code{\link{fit.mle}} or \code{MSGARCH_BAY_FIT}
created with \code{\link{fit.bayes}}.}

\item{theta}{Vector (of size d) or matrix (of size M x d) of parameter estimates (not require when using a fit object).}
}
\value{
Unconditional volatility (vector of size K or matrix of size M x K) of each regime.
}
\description{
Method returning the unconditional volatility of the process in each state.
}
\details{
If a matrix of parameter estimates is given, each parameter estimates is evaluated individually.
}
\examples{
# create model specification
spec = MSGARCH::create.spec() 

# compute the unconditional volatility in each regime
unc.vol = MSGARCH::unc.vol(object = spec, theta = spec$theta0)
}

