% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_S4_class_SRA.R
\docType{methods}
\name{plot.SRA}
\alias{plot.SRA}
\alias{plot,SRA,missing-method}
\title{Plot SRA scope output}
\usage{
\S4method{plot}{SRA,missing}(x, filename = "SRA_scope",
  dir = tempdir(), sims = 1:OM@nsim, Year = NULL, open_file = TRUE,
  quiet = TRUE, ...)
}
\arguments{
\item{x}{An object of class \linkS4class{SRA} (output from \link{SRA_scope}).}

\item{filename}{Character string for the name of the markdown and HTML files.}

\item{dir}{The directory in which the markdown and HTML files will be saved.}

\item{sims}{A logical vector of length \code{OM@nsim} or a numeric vector indicating which simulations to keep.}

\item{Year}{Optional, a vector of years for the historical period for plotting.}

\item{open_file}{Logical, whether the HTML document is opened after it is rendered.}

\item{quiet}{Logical, whether to silence the markdown rendering function.}

\item{...}{Other arguments to pass to \link[rmarkdown]{render}.}
}
\value{
Returns invisibly the output from \link[rmarkdown]{render}.
}
\description{
Produces HTML file (via markdown) figures of parameter estimates and output from an \linkS4class{Assessment} object.
Plots histograms of operating model parameters that are updated by the SRA scoping function, as well as diagnostic plots
for the fits to the SRA for each simulation.
}
\seealso{
\linkS4class{SRA} \link{SRA_scope}
}
