% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ancillary_Indicators.R
\name{Probs}
\alias{Probs}
\title{Calculates mahalanobis distance and rejection of the Null operating model}
\usage{
Probs(indPPD, indData, alpha = 0.05, removedat = FALSE,
  removethresh = 0.05)
}
\arguments{
\item{indPPD}{A 3D array of results arising from running getind on an MSE of the Null operating model (type of data/stat (e.g. mean catches),time period (chunk), simulation)}

\item{indData}{A 3D array of results arising from running getind on an MSE of the Alternative operating model (type of data/stat (e.g. mean catches),time period (chunk), simulation)}

\item{alpha}{Positive fraction: rate of type I error, alpha}

\item{removedat}{Logical, should data not contributing to the mahalanobis distance be removed?}

\item{removethresh}{Positive fraction: the cumulative percentage of removed data (removedat=TRUE) that contribute to the mahalanobis distance}
}
\value{
A list object.
 Position 1 is an array of the mahalanobis distances. Dimension 1 is length 2 for the Null OM (indPPD) and the alternative OM (indData).
 Dimension 2 is the time block (same length as indPPD dim 2). Dimension 3 is the simulation number (same length at indPPD dim 3.),
 Position 2 is a matrix (2 rows, ntimeblock columns) which is (row 1) alpha: the rate of false positives, and row 2 the power (1-beta) the rate of true positives
}
\description{
Calculates mahalanobis distance and rejection of the Null operating model, used by wrapping function \link{PRBcalc}.
}
\references{
Carruthers and Hordyk 2018
}
\author{
T. Carruthers
}
