% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCA.R, R/SCA2.R
\name{SCA}
\alias{SCA}
\alias{SCA2}
\title{Statistical catch-at-age (SCA) model}
\usage{
SCA(x = 1, Data, SR = c("BH", "Ricker"), vulnerability = c("logistic",
  "dome"), CAA_multiplier = 50, I_type = c("B", "VB", "SSB"),
  rescale = "mean1", start = NULL, fix_h = FALSE,
  fix_U_equilibrium = TRUE, fix_sigma = FALSE, fix_tau = TRUE,
  early_dev = c("comp_onegen", "comp", "all"), late_dev = "comp50",
  integrate = FALSE, silent = TRUE, opt_hess = FALSE,
  n_restart = ifelse(opt_hess, 0, 1), control = list(iter.max = 5000,
  eval.max = 10000), inner.control = list(), ...)

SCA2(x = 1, Data, SR = c("BH", "Ricker"), vulnerability = c("logistic",
  "dome"), CAA_multiplier = 50, I_type = c("B", "VB", "SSB"),
  rescale = "mean1", start = NULL, fix_h = FALSE,
  fix_U_equilibrium = TRUE, fix_sigma = FALSE, fix_tau = TRUE,
  common_dev = "comp50", integrate = FALSE, silent = TRUE,
  opt_hess = FALSE, n_restart = ifelse(opt_hess, 0, 1),
  control = list(iter.max = 5000, eval.max = 10000), inner.control = list(),
  ...)
}
\arguments{
\item{x}{A position in the Data object (by default, equal to one for assessments).}

\item{Data}{An object of class Data}

\item{SR}{Stock-recruit function (either \code{"BH"} for Beverton-Holt or \code{"Ricker"}).}

\item{vulnerability}{Whether estimated vulnerability is \code{"logistic"} or \code{"dome"} (double-normal).
See details for parameterization.}

\item{CAA_multiplier}{Numeric for data weighting of catch-at-age matrix. See details.}

\item{I_type}{Whether the index surveys population biomass (B; this is the default in the DLMtool operating model),
vulnerable biomass (VB), or spawning stock biomass (SSB).}

\item{rescale}{A multiplicative factor that rescales the catch in the assessment model, which
can improve convergence. By default, \code{"mean1"} scales the catch so that time series mean is 1, otherwise a numeric.
Output is re-converted back to original units.}

\item{start}{Optional list of starting values. See details.}

\item{fix_h}{Logical, whether to fix steepness to value in \code{Data@steep} in the model for \code{SCA}. This only affects
calculation of reference points for \code{SCA2}.}

\item{fix_U_equilibrium}{Logical, whether the equilibrium harvest rate prior to the first year of the model
is estimated. If \code{TRUE}, \code{U_equilibrium} is fixed to value provided in \code{start} (if provided),
otherwise, equal to zero (assumes virgin conditions).}

\item{fix_sigma}{Logical, whether the standard deviation of the index is fixed. If \code{TRUE},
sigma is fixed to value provided in \code{start} (if provided), otherwise, value based on \code{Data@CV_Ind}.}

\item{fix_tau}{Logical, the standard deviation of the recruitment deviations is fixed. If \code{TRUE},
tau is fixed to value provided in \code{start} (if provided), otherwise, value based on \code{Data@sigmaR}.}

\item{early_dev}{Character string describing the years for which recruitment deviations are estimated in \code{SCA}. By default, \code{"comp_onegen"}
rec devs are estimated one full generation prior to the first year when catch-at-age (CAA) data are available. With \code{"comp"}, rec devs are
estimated starting in the first year with CAA. With \code{"all"}, rec devs start at the beginning of the model.}

\item{late_dev}{Typically, a numeric for the number of most recent years in which recruitment deviations will
not be estimated in \code{SCA} (recruitment in these years will be based on the mean predicted by stock-recruit relationship).
By default, \code{"comp50"} uses the number of ages (smaller than the mode)
for which the catch-at-age matrix has less than half the abundance than that at the mode.}

\item{integrate}{Logical, whether the likelihood of the model integrates over the likelihood
of the recruitment deviations (thus, treating it as a state-space variable).}

\item{silent}{Logical, passed to \code{\link[TMB]{MakeADFun}}, whether TMB
will print trace information during optimization. Used for dignostics for model convergence.}

\item{opt_hess}{Logical, whether the hessian function will be passed to \code{\link[stats]{nlminb}} during optimization
(this generally reduces the number of iterations to convergence, but is memory and time intensive and does not guarantee an increase
in convergence rate). Ignored if \code{integrate = TRUE}.}

\item{n_restart}{The number of restarts (calls to \code{\link[stats]{nlminb}}) in the optimization procedure, so long as the model
hasn't converged. The optimization continues from the parameters from the previous (re)start.}

\item{control}{A named list of agruments for optimization to be passed to
\code{\link[stats]{nlminb}}.}

\item{inner.control}{A named list of arguments for optimization of the random effects, which
is passed on to \code{\link[TMB]{newton}}.}

\item{...}{Other arguments to be passed.}

\item{common_dev}{Typically, a numeric for the number of most recent years in which a common recruitment deviation will
be estimated (in \code{SCA2}, uninformative years will have a recruitment closer to the mean, which can be very misleading,
especially near the end of the time series). By default, \code{"comp50"} uses the number of ages (smaller than the mode)
for which the catch-at-age matrix has less than half the abundance than that at the mode.}
}
\value{
An object of class \linkS4class{Assessment}.
}
\description{
A generic statistical catch-at-age model (single fleet, single season) that uses catch, index, and catch-at-age composition
data. An annual harvest rate is calculated (assuming a pulse fishery) as described in Forrest et al. (2008).
There are two parameterizations for estimation of recruitment deviations, the stock-recruit relationship,
and reference points (see functions section below).
}
\details{
For the statistical catch-at-age model, the basic data inputs are catch (by weight), index
(by weight/biomass), and catch-at-age matrix (by numbers). Catches are
assumed to be known perfectly (the harvest rate in a given year is the ratio of the observed
catch to the vulnerable biomass at the beginning of the year).

The annual sample sizes of the catch-at-age matrix is provided to the model (used in the
likelihood for catch-at-age, assuming a multinomial distribution),
and is manipulated via argument \code{CAA_multiplier}. This argument is
interpreted in two different ways depending on the value provided.
If \code{CAA_multiplier > 1}, then this value will cap the annual sample sizes
to that number. If \code{CAA_multiplier <= 1}, then all the annual samples sizes
will be re-scaled by that number. By default, sample sizes are capped at 50.

Vulnerability can be specified to be either logistic or dome. If logistic, then the model
vector \code{vul_par} is of length 2:
\itemize{
\item \code{vul_par[1]}: \code{a50}, the age of 50\% vulnerability.
\item \code{vul_par[2]}: the age of 95\% vulnerability (a95) as an offset, i.e., \code{a95 = a50 + exp(vul_par[2])}.
}

With dome vulnerability, a double normal parameterization is used, where \code{vul_par}
is an estimated vector of length 4:
\itemize{
\item \code{vul_par[1]}: \code{log(sd_asc)}, where sd_asc is the standard deviation of the normal distribution function for the ascending limb
\item \code{vul_par[2]}: \code{mu_asc}, the mean of the normal distribution function for the ascending limb
\item \code{vul_par[3]}: \code{mu_des}, mean of the normal distribution function for the descending limb parameterized as an offset,
i.e., \code{mu_desc = mu_asc + exp(vul_par[3])} to ensure \code{mu_desc > mu_asc}. The vulnerability is 1 for ages between mu_asc and mu_desc.
\item \code{vul_par[4]}: \code{log(sd_des)}, where sd_des is the standard deviation of the normal distribution function for the descending limb.
}

For \code{start}, a named list of starting values of estimates for:
\itemize{
\item \code{R0} Virgin recruitment, only for \code{SCA}.
\item \code{h} Steepness, only for \code{SCA}. If not provided, the value in \code{Data@steep} is used.
\item \code{meanR} Mean recruitment, only for \code{SCA2}.
\item \code{U_equilibrium}. Harvest rate prior to the first year of model, e.g. zero means virgin conditions.
\item \code{vul_par} (length 2 vector for logistic or length 4 for dome, see above).
\item \code{sigma} Standard deviation of index.
\item \code{tau} Standard deviation of recruitment deviations. If not provided, the value in \code{Data@sigmaR} is used.
}
}
\section{Functions}{
\itemize{
\item \code{SCA}: The parameterization with R0 and steepness as leading parameters. Recruitment is estimated
as deviations from the resulting stock-recruit relationship.

\item \code{SCA2}: The mean recruitment in the time series is estimated and recruitment deviations around this mean are estimated
as penalized parameters (similar to Cadigan 2016). This version is generally very fast and robust. Virgin and MSY reference points
are estimated after the assessment run.
}}

\note{
For a given catch history, the starting value of \code{R0} or \code{meanR} may be too low and the population crashes in
the middle of the time series. If the assessment function detects this pattern is occurring, it will increase \code{R0} or \code{meanR}
before running the model.
}
\section{Required Data}{

\itemize{
\item \code{SCA}: Cat, Ind, Mort, L50, L95, CAA, vbK, vbLinf, vbt0, wla, wlb, MaxAge
\item \code{SCA2}: Cat, Ind, Mort, L50, L95, CAA, vbK, vbLinf, vbt0, wla, wlb, MaxAge
}
}

\section{Optional Data}{

\itemize{
\item \code{SCA}: Rec, steep, sigmaR, CV_Ind
\item \code{SC2}: Rec, steep, CV_Ind
}
}

\examples{
\donttest{
res <- SCA(Data = DLMtool::SimulatedData)
res2 <- SCA2(Data = DLMtool::Simulation_1)
}
}
\references{
Cadigan, N.G. 2016. A state-space stock assessment model for northern cod, including under-reported catches and
variable natural mortality rates. Canadian Journal of Fisheries and Aquatic Science 72:296-308.

Forrest, R.E., Martell, S.J.D., Melnychuk, M.C., and Walters, C.J. 2008.
An age-structured model with leading management parameters, incorporating
age-specific selectivity and maturity. Canadian Journal of Fisheries and Aquatic
Science 65:286-296.
}
\seealso{
\link{plot,Assessment,ANY-method} \link{summary,Assessment-method} \link{retrospective} \link{profile_likelihood} \link{make_MP}
}
\author{
Q. Huynh
}
