% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mram.R
\name{mram}
\alias{mram}
\title{Estimate Multivariate Regression Association Measure}
\usage{
mram(
  y_data,
  x_data,
  z_data = NULL,
  bootstrap = FALSE,
  B = 1000,
  g_vec = seq(0.4, 0.9, by = 0.05)
)
}
\arguments{
\item{y_data}{A \eqn{n \times d} matrix of responses.}

\item{x_data}{A \eqn{n \times p} Matrix of predictors.}

\item{z_data}{A \eqn{n \times q} matrix of conditional predictors.}

\item{bootstrap}{Perform the \eqn{m}-out-of-\eqn{n} bootstrap if \code{TRUE}. The default value is \code{FALSE}.}

\item{B}{Number of bootstrap replications. The default value is \code{1000}.}

\item{g_vec}{A vector used to generate a collection of rules for the \eqn{m}-out-of-\eqn{n} bootstrap. The default value is \code{seq(0.4,0.9,by = 0.05)}.}
}
\value{
\item{T_est}{The estimate of the multivariate regression association measure.}
\item{T_se_cluster}{The standard error estimate based on the cluster rule.}
\item{m_vec}{The vector of \eqn{m} generated by \code{g_vec}.}
\item{T_se_vec}{The vector of standard error estimates obtained from the \eqn{m}-out-of-\eqn{n} bootstrap, where \eqn{m} is equal to \code{m_vec}.}
\item{J_cluster}{The index of the best \code{m_vec} chosen by the cluster rule.}
}
\description{
Estimate the multivariate regression association measure proposed in Shih and Chen (2025). Standard error estimates are obtained by applying the \eqn{m}-out-of-\eqn{n} bootstrap proposed in Dette and Kroll (2024).
}
\details{
The value \code{T_est} returned by \code{mram} is between \eqn{-1} and \eqn{1}. However, it is between \eqn{0} and \eqn{1} asymptotically. A small value indicates that \code{x_data} has low predictability for \code{y_data} condition on \code{z_data} in the sense of the considered measure. Similarly, a large value indicates that \code{x_data} has high predictability for \code{y_data} condition on \code{z_data}. If \code{z_data = NULL}, the returned value indicates the unconditional predictability.
}
\examples{
n = 100
lambda_para = 3
sigma_para = 0.4

x_data = matrix(rnorm(n*2),n,2)
y_data = matrix(0,n,2)
y_data[,1] = x_data[,1]+x_data[,2]+lambda_para*sigma_para*rnorm(n)
y_data[,2] = x_data[,1]-x_data[,2]+lambda_para*sigma_para*rnorm(n)

library(MRAM)
res = mram(y_data,x_data,bootstrap = FALSE)
}
\references{
Dette and Kroll (2024) A Simple Bootstrap for Chatterjee’s Rank Correlation, Biometrika, asae045.

Shih and Chen (2025) Measuring multivariate regression association via spatial sign (in revision, Computational Statistics & Data Analysis)
}
\seealso{
\code{\link{vs_mram}}
}
