% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fisheries.r
\name{mature}
\alias{mature}
\title{mature alternative logistic function commonly used for maturity}
\usage{
mature(a, b, sizeage)
}
\arguments{
\item{a}{is the intercept of the exponential function usually -ve}

\item{b}{is the gradient of the exponential function}

\item{sizeage}{is a vector of lengths/ages for which the logistic 
maturity value will be calculated}
}
\value{
A vector of predicted proportion mature for the sizeage
}
\description{
mature a function 1/(1+(1/exp(a + b x sizeage))) which can
    be expressed as exp(a + b x sizeage)/(1 + exp(a + b x sizeage)).
    This describes a symmetric logistic curve that has the property
    Lm50 = -a/b and the interquartile distance is 2.log(3)/b.
}
\examples{
a <- -14.383
b <- 0.146017
lens <- seq(2,210,2)
round(mature(a,b,sizeage=lens),5) # length based
round(mature(-2.5,0.95,0:25),5)   # age based
}
