% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotfuns.R
\name{setpalette}
\alias{setpalette}
\title{setpalette is a shortcut for altering the palette to R4}
\usage{
setpalette(x = "R4")
}
\arguments{
\item{x}{either "default", "R3", or "R4", with R4 as the 
default value. Use "default" or "R3" to revert back to the
standard R version 3. values.}
}
\value{
nothing but it does alter the base colour palette
}
\description{
setpalette is a shortcut for changing the 
    default color palette to the proposed new R version 4.0.0 
    version before it comes out. The new palette was described in a
    blog post at developer.r-project.org and provides less 
    garish and a more visible set of default colours that can
    be called using the numbers 1 - 8. An important point is 
    that this alters the default colours for all sessions
    until a restart of R. Using something similar you can 
    define your own preferred palettes should you wish to.
}
\examples{
   setpalette("R3")
   plot(1:8,rep(0.25,8),type="p",pch=16,cex=5,col=c(1:8))
   text(1,0.2,"Default R3.0.0 - some garish or pale",cex=1.5,
        font=7,pos=4)
   setpalette("R4")
   points(1:8,rep(0.3,8),pch=16,cex=5,col=c(1:8)) #toprow
   text(1,0.325,"Default R4.0.0 - more balanced",cex=1.5,
        font=7,pos=4)
}
