% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fisheries.r
\name{Gz}
\alias{Gz}
\title{Gz calculates predicted Gompertz length-at-age growth curve}
\usage{
Gz(p, ages)
}
\arguments{
\item{p}{is a vector the first three cells of which are a, b, c, for
the Gz curve.}

\item{ages}{is a vector of ages; could be a single number}
}
\value{
a vector of predicted lengths for a vector of ages in 'ages'
}
\description{
Gz calculates length-at-age for the Gompertz curve.
    This curve can have an inflection near the origin as well
    as at an age where growth slows due to maturity occurring.
}
\examples{
 ages <- seq(0,20,1)   # sigma is ignored here
 oldpar <- par(no.readonly=TRUE)
 pars <- c(a=26.0,b=2.8,c=-0.65,sigma=1.0) # a, b, c, sigma;
 plot1(ages,Gz(pars,ages),xlab="Age",ylab="Length",lwd=2)
 par(oldpar)
}
