% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d.dep.t.diff.R
\name{d.dep.t.diff}
\alias{d.dep.t.diff}
\title{d for Dependent t with SD Difference Scores Denominator}
\usage{
d.dep.t.diff(mdiff, sddiff, n, a = 0.05)
}
\arguments{
\item{mdiff}{mean difference score}

\item{sddiff}{standard deviation of the difference scores}

\item{n}{sample size}

\item{a}{significance level}
}
\value{
The effect size (Cohen's d) with associated confidence intervals, mean
differences with associated confidence intervals, standard
deviation of the differences, standard error, sample size, degrees of
freedom, the t-statistic, and the p-value.

\item{d}{effect size}
\item{dlow}{lower level confidence interval d value}
\item{dhigh}{upper level confidence interval d value}
\item{mdiff}{mean difference score}
\item{Mlow}{lower level of confidence interval of the mean}
\item{Mhigh}{upper level of confidence interval of the mean}
\item{sddiff}{standard deviation of the difference scores}
\item{n}{sample size}
\item{df}{degrees of freedom (sample size - 1)}
\item{t}{t-statistic}
\item{p}{p-value}
\item{estimate}{the d statistic and confidence interval in
APA style for markdown printing}
\item{statistic}{the t-statistic in APA style for markdown printing}
}
\description{
This function displays d and the non-central confidence interval
for repeated measures data, using the standard deviation
of the difference score as the denominator.
}
\details{
To calculate d, the mean difference score is divided by
divided by the standard deviation of the difference scores.

d_z = mdiff / sddiff

\href{https://www.aggieerin.com/shiny-server/tests/deptdiffm.html}{Learn more on our example page.}
}
\examples{

#The following example is derived from the "dept_data" dataset included
#in the MOTE library.

#In a study to test the effects of science fiction movies on people's
#belief in the supernatural, seven people completed a measure of belief
#in the supernatural before and after watching a popular science fiction movie.
#Higher scores indicated higher levels of belief. The mean difference score was 1.14,
#while the standard deviation of the difference scores was 2.12.

#You can type in the numbers directly as shown below,
#or refer to your dataset within the function.

    d.dep.t.diff(mdiff = 1.14, sddiff = 2.12, n = 7, a = .05)

    d.dep.t.diff(1.14, 2.12, 7, .05)

    d.dep.t.diff(mdiff = mean(dept_data$before - dept_data$after),
                 sddiff = sd(dept_data$before - dept_data$after),
                 n = length(dept_data$before),
                 a = .05)

#The mean measure of belief on the pretest was 5.57, with a standard
#deviation of 1.99. The posttest scores appeared lower (M = 4.43, SD = 2.88)
#but the dependent t-test was not significant using alpha = .05,
#t(7) = 1.43, p = .203, d_z = 0.54. The effect size was a medium
#effect suggesting that the movie may have influenced belief
#in the supernatural.

}
\keyword{dependent}
\keyword{effect}
\keyword{size,}
\keyword{t-test}
