% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ls_tpqa.R
\name{ls_tpqa}
\alias{ls_tpqa}
\title{Three-point quadratic approximation local search}
\usage{
ls_tpqa(
  Xt,
  Yt,
  W,
  B,
  Vt,
  scaling,
  aggfun,
  constraint,
  epsilon = 1e-06,
  which.x,
  ...
)
}
\arguments{
\item{Xt}{Matrix of incumbent solutions}

\item{Yt}{Matrix of objective function values for Xt}

\item{W}{matrix of weights (generated by \code{\link[=generate_weights]{generate_weights()}}).}

\item{B}{Neighborhood matrix, generated by \code{\link[=define_neighborhood]{define_neighborhood()}}.}

\item{Vt}{List object containing information about the constraint violations
of the \emph{incumbent solutions}, generated by \code{\link[=evaluate_population]{evaluate_population()}}}

\item{scaling}{list containing the scaling parameters (see \code{\link[=moead]{moead()}} for
details).}

\item{aggfun}{List containing the aggregation function parameters. See
Section \verb{Scalar Aggregation Functions} of the \code{\link[=moead]{moead()}} documentation for
details.}

\item{constraint}{list containing the parameters defining the constraint
handling method. See Section \verb{Constraint Handling} of the \code{\link[=moead]{moead()}}
documentation for details.}

\item{epsilon}{threshold for using the quadratic approximation value}

\item{which.x}{logical vector indicating which subproblems should undergo
local search}

\item{...}{other parameters (included for compatibility with generic call)}
}
\value{
Matrix \code{X}' containing the modified population
}
\description{
Three-point quadratic approximation (TPQA) local search implementation for
the MOEA/D
}
\details{
This routine implements the 3-point quadratic approximation local search for
the MOEADr package. Check the references for details.

This routine is intended to be used internally by \code{\link[=variation_localsearch]{variation_localsearch()}},
and should not be called directly by the user.
}
\section{References}{

Y. Tan, Y. Jiao, H. Li, X. Wang,
"A modification to MOEA/D-DE for multiobjective optimization problems with
complicated Pareto sets",
Information Sciences 213(1):14-38, 2012.\cr

Y.-C. Jiao, C. Dang, Y. Leung, Y. Hao,
"A modification to the new version of the prices algorithm for continuous
global optimization problems",
J. Global Optimization 36(4):609-626, 2006.\cr

F. Campelo, L.S. Batista, C. Aranha (2020): The {MOEADr} Package: A
Component-Based Framework for Multiobjective Evolutionary Algorithms Based on
Decomposition. Journal of Statistical Software \doi{10.18637/jss.v092.i06}\cr
}

