% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_weights.R
\name{generate_weights}
\alias{generate_weights}
\title{Calculate weight vectors}
\usage{
generate_weights(decomp, m, ...)
}
\arguments{
\item{decomp}{List containing the decomposition method parameters. See
\code{\link[=moead]{moead()}} for details.}

\item{m}{Number of objectives (\eqn{m \ge 2})}

\item{...}{other parameters (included for compatibility with generic call)}
}
\value{
Weight matrix \code{W}
}
\description{
Calculates weight vectors for the MOEADr package
}
\details{
This routine calculates the weight vectors for the MOEA/D. The
list of available methods for generating the weights, as well as information
about their specific parameters, can be generated using
\code{get_decomposition_methods()}.
}
\examples{
decomp <- list(name = "sld", H = 99)
W <- generate_weights(decomp, m = 2)

}
