% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scalarization_awt.R
\name{scalarization_awt}
\alias{scalarization_awt}
\title{Adjusted Weighted Tchebycheff Scalarization}
\usage{
scalarization_awt(Y, W, minP, eps = 1e-16, ...)
}
\arguments{
\item{Y}{matrix of objective function values}

\item{W}{matrix of weights.}

\item{minP}{numeric vector containing estimated ideal point}

\item{eps}{tolerance value for avoiding divisions by zero.}

\item{...}{other parameters (included for compatibility with generic call)}
}
\value{
Vector of scalarized performance values.
}
\description{
Perform Adjusted Weighted Tchebycheff Scalarization for the MOEADr package.
}
\details{
This routine calculates the scalarized performance values for the MOEA/D
using the Adjusted Weighted Tchebycheff method.
}
\section{References}{

Y. Qi, X. Ma, F. Liu, L. Jiao, J. Sun, and J. Wu, “MOEA/D with
adaptive weight adjustment,” Evolutionary Computation, vol. 22,
no. 2, pp. 231–264, 2013.

R. Wang, T. Zhang, and B. Guo, “An enhanced MOEA/D using uniform
directions and a pre-organization procedure,” in IEEE Congress on
Evolutionary Computation, Cancn, Mxico, 2013, pp. 2390–2397.
}

