% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mt_write.R
\name{mt_write}
\alias{mt_write}
\title{Write a MODISTools data structure to file}
\usage{
mt_write(df = NULL, out_dir = tempdir())
}
\arguments{
\item{df}{a nested data structure of class MODISTools}

\item{out_dir}{output directory where to store data}
}
\value{
writes MODISTools data structure to file, retains proper header info.
}
\description{
Writes a nested data structure of class MODISTools to file.
}
\examples{

\donttest{
# download data
subset <- mt_subset(product = "MOD11A2",
                        lat = 40,
                        lon = -110,
                        band = "LST_Day_1km",
                        start = "2004-01-01",
                        end = "2004-02-01")
# write the above file to disk
mt_write(df = subset,
             out_dir = tempdir())

# read the data back in
subset_disk <- mt_read(paste0(tempdir(),
               "/sitename_MOD11A2_2004-01-01_2004-02-01.csv"))

# compare original to read from disk
identical(subset, subset_disk)
}
}
\keyword{IO}
\keyword{series,}
\keyword{time}
