% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractDate.R
\name{extractDate}
\alias{extractDate}
\title{Extract Dates from (MODIS) Files}
\usage{
extractDate(files, pos1 = 10, pos2 = 16, asDate = FALSE,
  format = "\%Y\%j")
}
\arguments{
\item{files}{\code{character} vector of filenames from which to extract 
dates.}

\item{pos1}{\code{integer}, start of date string in \code{files}.}

\item{pos2}{\code{integer}, end of date string.}

\item{asDate}{\code{logical}. If \code{TRUE}, the result is converted to a 
\code{Date} object.}

\item{format}{\code{character}, date format. Used only if \code{asDate = TRUE}. 
Defaults to MODIS date style (i.e., \code{"\%Y\%j"} for year and julian day). 
See \code{\link{strptime}} for modifications.}
}
\value{
A \code{list} with the following entries: 'inputLayerDates', 'pos1', 'pos2', 
'asDate' and, optionally, 'format'. If \code{asDate = FALSE}, 
'inputLayerDates' are represented as \code{character}, else as \code{Date}.
}
\description{
This function helps to extract dates from a vector of files.
}
\examples{
\dontrun{
# example on HDF files
files <- c("MOD13Q1.A2010209.h18v03.005.2010239071130.hdf",
           "MOD13Q1.A2010225.h18v03.005.2010254043849.hdf")
extractDate(files)
extractDate(files,asDate=TRUE)

# on any other file 
files <- c("Myfile_20010101.XXX","Myfile_20010115.XXX","Myfile_20010204.XXX")
extractDate(files,pos1=8,pos2=15)
extractDate(files,pos1=8,pos2=15,asDate=TRUE,format="\\\%Y\\\%m\\\%d")
}
 
}
\author{
Matteo Mattiuzzi
}
