% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MNormTest.R
\name{meanTest.two}
\alias{meanTest.two}
\title{Two Mean Vectors Hypothesis Testing}
\usage{
meanTest.two(
  data1,
  data2,
  alpha = 0.05,
  equal = TRUE,
  method = c("None", "Coupled", "Transformed"),
  verbose = TRUE
)
}
\arguments{
\item{data1}{A matrix or data frame of group 1.}

\item{data2}{A matrix or data frame of group 2.}

\item{alpha}{The significance level. Default is 0.05.}

\item{equal}{A boolean value. Default is TRUE. If TRUE, the covariance matrix is equal. If FALSE, the covariance matrix is not equal.}

\item{method}{A string value. Default is "None". When equal is FALSE, you must choose a method in "Coupled" or "Transformed". Choose "Coupled" when the sample size of two groups is equal. Choose "Transformed" when the sample size of two groups is not equal.}

\item{verbose}{A boolean value. Default is TRUE. If TRUE, the null hypothesis will be displayed. If FALSE, the test will be carried out silently.}
}
\value{
An object of class "testResult", which is a list with the following elements:
Return when the param equal is TRUE.
\item{Conclusion}{The conclusion of the test.}
\item{Stat}{A data frame containing the statistics, p value and critical value.}
\item{SampMean1}{The sample mean of group 1.}
\item{SampMean2}{The sample mean of group 2.}
\item{SampA1}{The sample deviation of group 1.}
\item{SampA2}{The sample deviation of group 2.}
\item{MixSampA}{The mixed sample deviation.}
\item{Df}{The degree of freedom.}
Return when the param equal is FALSE and method is "Coupled".
\item{Conclusion}{The conclusion of the test.}
\item{Stat}{A data frame containing the statistics, p value and critical value.}
\item{SampMeanC}{The sample mean of coupled data.}
\item{SampAC}{The sample deviation of coupled data.}
\item{Df}{The degree of freedom.}
\item{dataC}{The coupled data.}
Return when the param equal is FALSE and method is "Transformed".
\item{Conclusion}{The conclusion of the test.}
\item{Stat}{A data frame containing the statistics, p value and critical value.}
\item{SampMeanT}{The sample mean of transformed data.}
\item{SampAT}{The sample deviation of transformed data.}
\item{Df}{The degree of freedom.}
\item{dataT}{The transformed data. Return when the param equal is FALSE and method is "Transformed".}
}
\description{
Test whether the mean vectors of two multivariate normal populations are equal when the covariance matrices are equal or unequal. The null hypothesis is that "H0: mu1 = mu2".
}
\examples{
data(iris)
X <- iris[1:50, 1:4]
Y <- iris[51:100, 1:4]
# carry out the test
test1 <- meanTest.two(X, Y)
test2 <- meanTest.two(X, Y, verbose = TRUE)
test3 <- meanTest.two(X, Y, equal = FALSE, method = "Coupled")
test4 <- meanTest.two(X, Y, equal = FALSE, method = "Transformed")
# get the elements
test1$Stat
test1$SampMean1
test3$SampMeanC
test4$dataT
}
\references{
Huixuan, Gao. Applied Multivariate Statistical Analysis. Peking University Press, 2005: pp.76-80.
}
\author{
Xifeng Zhang
}
