% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enveSim.R
\name{envelope.MNB}
\alias{envelope.MNB}
\title{Simulation envelope}
\usage{
envelope.MNB(star, formula, dataSet, n.r, nsim, plot = TRUE)
}
\arguments{
\item{star}{Initial values for the parameters to be optimized over.}

\item{formula}{The structure matrix of covariates of dimension n x p (in models that include an intercept x
should contain a column of ones).}

\item{dataSet}{data}

\item{n.r}{Indicator which residual type graphics. 1 - weighted, 2 - Standardized weighted, 3 - Pearson, 4 - Standardized Pearson, 5 - standardized deviance component residuals and 6 - randomized quantile residuals.}

\item{nsim}{Number of Monte Carlo replicates.}

\item{plot}{TRUE or FALSE. Indicates if a graph should be plotted.}
}
\value{
L, residuals and simulation envelopes in normal probability plots
}
\description{
Simulated envelopes in normal probability plots
}
\details{
Atkinson (1985), suggests the use of simulated envelopes in normal probability
plots to facilitate the goodness of fit.
}
\examples{

\donttest{

data(seizures)
head(seizures)

star <-list(phi=1, beta0=1, beta1=1, beta2=1, beta3=1)

envelope.MNB(formula=Y ~ trt + period + trt:period +
offset(weeks),star=star,nsim=21,n.r=6,
dataSet=seizures,plot=FALSE)

data(alzheimer)
head(alzheimer)

star <- list(phi=10,beta1=2, beta2=0.2)
envelope.MNB(formula=Y ~ trat, star=star, nsim=21, n.r=6,
dataSet = alzheimer,plot=FALSE)

}
}
\references{
\itemize{
\item Atkinson A.C. (1985). Plots, Transformations and Regression: An Introduction to Graphical Methods of Diagnostic
Regression Analysis. Oxford University Press, New York.
\item Fabio, L. C., Villegas, C., Carrasco, J. M. F., and de Castro, M. (2021). D
Diagnostic tools for a multivariate negative binomial model for fitting correlated data with
overdispersion. Communications in Statistics - Theory and Methods.
https://doi.org/10.1080/03610926.2021.1939380.

}
}
\author{
Jalmar M F Carrasco <carrascojalmar@gmail.com>,
Cristian M Villegas Lobos <master.villegas@gmail.com> and Lizandra C Fabio <lizandrafabio@gmail.com>
}
