% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_utils.R
\name{plot_loss_curve}
\alias{plot_loss_curve}
\title{Plot Neural Network Loss Curve}
\usage{
plot_loss_curve(analysis_object)
}
\arguments{
\item{analysis_object}{Fitted analysis_object with 'fine_tuning()'.}
}
\value{
analysis_object
}
\description{
Plots the training loss curve of the Neural Network model on the validation set. This plot can be used
for underfitting / overfitting diagnostics.
}
\examples{

# Note: For obtaining the loss curve plot the user needs to
# complete till the fine_tuning( ) function of the MLwrap pipeline.

if (requireNamespace("torch", quietly = TRUE)) {

  \donttest{

  wrap_object <- preprocessing(df = sim_data,
                             formula = psych_well ~ depression + emot_intel + resilience,
                             task = "regression")
  wrap_object <- build_model(wrap_object, "Neural Network")
  wrap_object <- fine_tuning(wrap_object, "Bayesian Optimization")

  # And then, you can obtain the loss curve plot.

  plot_loss_curve(wrap_object)

  }

}

}
