#' Thai data from PISA
#'
#' Example data to be used for centering
#' @usage data(thai)
#' @format A data frame with 6606 rows and 18 variables:
#' \describe{
#'   \item{pv1math}{First plausible value in mathematics.}
#'   \item{escs}{Index of economic, social, and cultural status.}
#'   \item{hisei}{Highest parent occupational status.}
#'   \item{sex}{Student gender. 1 = Female, 2 = Male.}
#'   \item{intmat}{Mathematics interest.}
#'   \item{matheff}{Mathematics self-efficacy.}
#'   \item{schoolid}{School identifier}
#'   \item{othl}{Spoke another language at home other than Thai. 1 = yes, 0 = no.}
#'   \item{books}{How many books at home.}
#'   \item{pared}{Highest parental education in years.}
#'   \item{w_fstuwt}{Student weight.}
#'   \item{pv1read}{Plausible value #1 for reading.}
#'   \item{pv2read}{Plausible value #2 for reading.}
#'   \item{pv3read}{Plausible value #3 for reading.}
#'   \item{pv4read}{Plausible value #4 for reading.}
#'   \item{pv5read}{Plausible value #5 for reading.}
#'   \item{private}{Private school. 1 = yes, 0 = no.}
#'   \item{schsize}{Total school enrolment.}
#' }
#' @source \url{https://gpseducation.oecd.org/CountryProfile?primaryCountry=THA}
"thai"
