% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orientation.R
\name{compute_orientation}
\alias{compute_orientation}
\title{Estimate the accelerometer orientation}
\usage{
compute_orientation(df, estimation_window = 2, unit = "deg")
}
\arguments{
\item{df}{dataframe. Input multi-channel signal. First column should be
timestamps in POSIXt format.}

\item{estimation_window}{number. window size in seconds to be used to
estimate orientations. Default is 2 (seconds), as suggested by
\href{https://ieeexplore.ieee.org/stamp/stamp.jsp?arnumber=1241424}{Mizell,
2003}.}

\item{unit}{string. The unit of orientation angles. Can be "deg" (degree) or
"rad" (radian). Default is "deg".}
}
\value{
dataframe. The returned dataframe will have the same format as input
  dataframe.
}
\description{
\code{compute_orientation} returns a dataframe with accelerometer
orientations estimated by
\href{https://ieeexplore.ieee.org/stamp/stamp.jsp?arnumber=1241424}{Mizell,
2003} for the input dataframe.
}
\details{
This function accepts a dataframe (in mhealth accelerometer data format) and
computes the estimated acclerometer orientations (in x, y, and z angles) for
every \code{estimation_window} seconds of the entire sequence, and outputs
the mean of these angles. The returned dataframe will have the same format as
input dataframe, including four columns, and have the same datetime format as
input dataframe in the timestamp column. The orientation estimation method
used in the function is based on
\href{https://ieeexplore.ieee.org/stamp/stamp.jsp?arnumber=1241424}{Mizell,
2003}.
}
\section{How is it used in mims-unit algorithm?}{
 This function is used in
  function (\code{\link{aggregate_for_orientation}}).
}

\examples{
  # Use first 10 second sample data for testing
  df = sample_raw_accel_data
  df = clip_data(df, start_time = df[1,1], stop_time = df[1, 1] + 600)

  # compute orientation angles in degrees
  compute_orientation(df)

  # compute orientation angles in radian angles
  compute_orientation(df, unit='rad')
}
\seealso{
Other transformation functions: 
\code{\link{sum_up}()},
\code{\link{vector_magnitude}()}
}
\concept{transformation functions}
