% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MIIVsem-data.R
\docType{data}
\name{bollen1996}
\alias{bollen1996}
\title{Perceived accessibility data}
\format{A data frame with 220 rows and 12 variables}
\usage{
bollen1996
}
\description{
Data come from a survey that was conducted in rural clusters of 
Tanzania in 1993. The goal was to collect information on the perceived 
accessibility of a specific family planning facility that serviced each 
cluster. Six informants were chosen: 3 female and 3 male. New informants 
were chosen for each cluster. Each informant was independently asked to 
rate the accessibility of the facility, and how easy it was to get to the
facility. More specifically the women informants were asked to rate how 
women of childbearing age perceived the accessibility and easiness and 
men were asked to rate how accessible and easy men perceived access to 
the clinic to be. Higher values indicate greater accessibility and ease 
of travel. The female informants' ratings are 1 to 3 and the male 
informants' ratings are 4 to 6.
}
\details{
\itemize{
  \item access1. 
  \item access2. 
  \item access3. 
  \item access4. 
  \item access5. 
  \item access6. 
  \item easy1. 
  \item easy2. 
  \item easy3. 
  \item easy4. 
  \item easy5. 
  \item easy6. 
}
}
\examples{

\dontrun{
 model <- ' 
    femaleAccess  =~ access1 + access2 + access3
    maleAccess    =~ access4 + access5 + access6
    femaleEasy    =~ easy1   + easy2   + easy3
    maleEasy      =~ easy4   + easy5   + easy6 
 '
}

}
\references{
Bollen, K. A., Speizer, I. S., & Mroz, T. A. (1996). Family Planning 
Facilities in Rural Tanzania: His and Her Perceptions of Time and Distance.
}
\keyword{datasets}
