% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\docType{methods}
\name{plot}
\alias{plot}
\alias{plot,mhmmresults-method}
\alias{plot,mhmmresults,numeric-method}
\alias{plot,mhmmresults,ANY-method}
\title{Plots of an instance of \code{\linkS4class{mhmmresults}}}
\usage{
\S4method{plot}{mhmmresults,numeric}(x, y,
  col = x@partitions$states[[y]], xlab = "Time", ylab = "Activity",
  ylim = range(na.omit(x@data@yi[[y]])))
}
\arguments{
\item{x}{instance of  \code{\linkS4class{mhmmresults}}.}

\item{y}{numeric index of the subject to visualize.}

\item{col}{numeric indicates the latent state at each time (length must be equal to the length of x)}

\item{xlab}{character label of the x-axis}

\item{ylab}{character label of the y-axis}

\item{ylim}{numeric range of the y-axis}
}
\description{
Plots of an instance of \code{\linkS4class{mhmmresults}}
}
\examples{
data(accelero)
# To make the estimation <5
res <- mhmm(accelero, K = 2, M = 4, nbcores = 1, nbinit = 5, iterSmall = 2)
plot(res, 1)

 \donttest{
data(accelero)
# It is better to increase the number of random initializations
res <- mhmm(accelero, K = 2, M = 4, nbcores = 1)
plot(res, 1)
}
}
