% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MGLMgen.R, R/pdfln.R
\name{rnegmn}
\alias{rnegmn}
\alias{negmn}
\alias{dnegmn}
\title{The Negative Multinomial Distribution}
\usage{
rnegmn(n, beta, prob)

dnegmn(Y, beta, prob = alpha/(rowSums(alpha) + 1), alpha = NULL)
}
\arguments{
\item{n}{number of random vectors to generate.  When \code{beta} is a scalar and \code{prob} is a vector, 
must specify \code{n}.  When \code{beta} is a vector and \code{prob} is a matrix, \code{n} is optional.
The default value of \code{n} is the length of \code{beta}. If given, \code{n} should be equal to 
the length of \code{beta}.}

\item{beta}{the over dispersion parameter of the negative multinomial distribution. \code{beta} can be either a scalar or a vector of length \eqn{n}.}

\item{prob}{the probability parameter of the negative multinomial distribution. Should be a numerical non-negative vector or matrix.

For \code{dnegmn}, \code{prob} can be either
a vector of length \eqn{d} \eqn{(d \ge 2)} or a matrix with matching size of \code{Y}.  
If \code{prob} is a vector, it will 
be replicated \eqn{n} times to match the dimension of \code{Y}.  The sum
of each row of \code{prob} should be smaller than 1. 

For \code{rnegmn}, If \code{prob} is a vector, \code{beta}
must be a scalar.  All the \code{n} random vectors will be drawn from the
same \code{prob} and \code{beta}.  If \code{prob} is a matrix, the number of rows should 
match the length of \code{beta}.  Each random vector will be drawn from
the corresponding row of \code{prob} and the corresponding element of \code{beta}. Each row of \code{prob} should have sum less than 1.}

\item{Y}{the multivariate response matrix of dimension \eqn{n \times d}{nxd}, 
where \eqn{n = 1, 2, \ldots} is number of observations and \eqn{d=2,3,\ldots} is number of categories.}

\item{alpha}{an alternative way to specify the probability. Default value is \code{NULL}. See details.}
}
\value{
\code{dnegmn} returns the value of 
\eqn{\log(P(y|p, \beta) )}{logP(y|p, \beta)}.  When \code{Y} is a matrix of \eqn{n} rows, the function
returns a vector of length \eqn{n}.

\code{rnegmn} returns a \eqn{n\times d}{nxd} matrix of the generated random observations.
}
\description{
\code{dnegmn} calculates the log of the negative multinomial probability mass function. 
\code{rnegmn} generates random observations from the negative multinomial distribution.
}
\details{
\eqn{y=(y_1, \ldots, y_d)} is a \eqn{d} category vector. Given the parameter vector \eqn{p= (p_1, \ldots, p_d)},
\eqn{p_{d+1} = 1/(1 + \sum_{j'=1}^d p_{j'})}{p_{d+1} = 1/(1 + sum_{j'=1}^d p_{j'})}, 
and \eqn{\beta}, \eqn{\beta>0}, the negative multinomial probability mass function is 
\deqn{
  P(y|p,\beta) =  C_{m}^{\beta+m-1}  C_{y_1, \ldots, y_d}^{m} 
  \prod_{j=1}^d p_j^{y_j} p_{d+1}^\beta = \frac{\beta_m}{m!}  {m \choose y_1, \ldots, y_d} \prod_{j=1}^d p_j^{y_j} p_{d+1}^\beta,
}{
  P(y|p,\beta) =  C_{m}^{\beta+m-1}  C_{y_1, \ldots, y_d}^{m} 
  prod_{j=1}^d p_j^{y_j} p_{d+1}^\beta = (\beta_m)/(m!) C_{y_1, \ldots, y_d}^{m} prod_{j=1}^d p_j^{y_j} p_{d+1}^\beta,
}
where \eqn{m = \sum_{j=1}^d y_j}{m = sum_{j=1}^d y_j}. Here, \eqn{C_k^n}, often read as "\eqn{n} choose \eqn{k}", 
refers the number of \eqn{k} combinations from a set of \eqn{n} elements.

\code{alpha} is an alternative way to specify the probability: 
\deqn{p_j = \frac{\alpha_j}{(1+\sum_{k=1}^{d} \alpha_k)}}{p_j = \alpha_j / (1+sum_{k=1}^{d} \alpha_k)} for \eqn{j=1,\ldots,d} and 
\eqn{p_{d+1} = \frac{1}{(1+\sum_{k=1}^{d} \alpha_k)}}{p_{d+1} = 1 / (1+sum_{k=1}^{d} \alpha_k)}. 

The parameter \code{prob} can be a vector and \code{beta} is a scalar; \code{prob} can also
be a matrix with \eqn{n} rows, and \code{beta} is a vector of length \eqn{n}
like the estimate from the regression function
multiplied by the covariate matrix.
}
\examples{
###-----------------------###
set.seed(128)
n <- 100
d <- 4
p <- 5
a <- -matrix(1,p,d)
X <- matrix(runif(n*p), n, p )
alpha <- exp(X\%*\%a)
prob <- alpha/(rowSums(alpha)+1)
beta <- exp(X\%*\%matrix(1,p)) 
Y <- rnegmn(n, beta, prob)

###-----------------------###
m <- 20
n <- 10
p <- 5
d <- 6
a <- -matrix(1,p,d)
X <- matrix(runif(n*p), n, p )
alpha <- exp(X\%*\%a)
prob <- alpha/(rowSums(alpha)+1)
b <- exp(X\%*\%rep(0.3,p)) 
Y <- rnegmn(prob=prob, beta=rep(10, n))
dnegmn(Y, b, prob)

}
\author{
Yiwen Zhang and Hua Zhou
}
\keyword{distribution}
\keyword{models}
