% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cube-SMendelian.R
\name{cubeMendelian}
\alias{cubeMendelian}
\title{Inheritance Cube: Mendelian}
\usage{
cubeMendelian(gtype = c("AA", "Aa", "aa"), eta = NULL, phi = NULL,
  omega = NULL, xiF = NULL, xiM = NULL, s = NULL)
}
\arguments{
\item{gtype}{Vector of genotypes, with the wild-type in the first position}

\item{eta}{Genotype-specific mating fitness}

\item{phi}{Genotype-specific sex ratio at emergence}

\item{omega}{Genotype-specific multiplicative modifier of adult mortality}

\item{xiF}{Genotype-specific female pupatory success}

\item{xiM}{Genotype-specific male pupatory success}

\item{s}{Genotype-specific fractional reduction(increase) in fertility}
}
\value{
Named list containing the inheritance cube, transition matrix, genotypes, wild-type allele,
and all genotype-specific parameters.
}
\description{
This function creates a Mendelian Inheritance Cube. It only handles simple,
alphabetic genotypes. \cr
The default is 3 alleles at 1 locus, but this can be extended to however many
alleles one is interested in, but only at 1 locus.
}
