% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{calcHaversine}
\alias{calcHaversine}
\title{Calculate Geodesic Distance - Haversine Method}
\usage{
calcHaversine(latLongs, r = 6378137)
}
\arguments{
\item{latLongs}{Two column matrix of latitudes/longitudes}

\item{r}{Earth radius. Default is WGS-84 radius}
}
\description{
This function calculates geodesic distance using the haversine method.
}
\examples{
# two-column matrix with latitude/longitude, in degrees
latLong = cbind(runif(n = 5, min = 0, max = 90),
                runif(n = 5, min = 0, max = 180))

# haversine distance formula
distMat = calcHaversine(latLongs = latLong)

}
