% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_fixed.R
\name{MFKnockoffs.create.fixed}
\alias{MFKnockoffs.create.fixed}
\title{Create fixed-design knockoff variables}
\usage{
MFKnockoffs.create.fixed(X, method = c("sdp", "equi"), sigma = NULL,
  y = NULL, randomize = F)
}
\arguments{
\item{X}{normalized n-by-p design matrix (n >= 2p)}

\item{method}{either 'equi' or 'sdp'  (default:'sdp')}

\item{sigma}{noise level, used to augment the data with extra rows if necessary (default: NULL)}

\item{y}{vector of observed responses, used to estimate the noise level if 'sigma' is not provided (default: NULL)}

\item{randomize}{whether the knockoffs are deterministic or randomized (default:False)}
}
\value{
An object of class "MFKnockoffs.variables". This object is a list 
 containing at least the following components:
 \item{X}{The n-by-p matrix of original variables (possibly augmented or transformed)}
 \item{X_k}{The n-by-p matrix of knockoff variables}
 \item{y}{The vector of observed responses (possibly augmented) }
}
\description{
Creates fixed-design knockoff variables for the original variables.
}
\references{
Barber and Candes,
  Controlling the false discovery rate via knockoffs. 
  Ann. Statist. 43 (2015), no. 5, 2055--2085.
  \href{https://projecteuclid.org/euclid.aos/1438606853}{https://projecteuclid.org/euclid.aos/1438606853}


Fixed-design knockoff assume a linear regression model for Y|X. Moreover, they only guarantee
FDR control with statistics satisfying the "sufficiency" property. In particular, the default
statistics with cross-validated lasso does not satisfy this property and should not be used
with fixed-design knockoffs.
}
\seealso{
Other methods for creating knockoffs: \code{\link{MFKnockoffs.create.approximate_gaussian}},
  \code{\link{MFKnockoffs.create.gaussian}}
}
