% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{mfastLmCpp}
\alias{mfastLmCpp}
\title{Fast marginal simple regresion analyses}
\usage{
mfastLmCpp(y, x, addintercept = TRUE)
}
\arguments{
\item{y}{A vector of outcomes.}

\item{x}{A matrix of regressor variables. Must have the same number of rows as the length of y. Missing variables are not handled}

\item{addintercept}{A logical that determines if the intercept should be included in all analyses (TRUE) or not (FALSE)}
}
\value{
A data frame with three variables: coefficients, stderr, and tstat that gives the slope estimate, the corresponding standard error, and their ratio for each column in x.
}
\description{
Fast computation of simple regression slopes for each predictor represented by a column in a matrix
}
\examples{
\dontrun{
  // Generate 100000 predictors and 100 observations
  x <- matrix(rnorm(100*100000))
  y <- rnorm(100, mean=x[,1])
  mfastLM_cpp(y, x)

}
}
\author{
Claus Ekstrom <claus@rprimer.dk>
}
