% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdmr.R
\name{summary.mixed.mdmr}
\alias{summary.mixed.mdmr}
\title{Summarizing Mixed MDMR Results}
\usage{
\method{summary}{mixed.mdmr}(object, ...)
}
\arguments{
\item{object}{Output from \code{\link{mixed.mdmr}}}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Calling
\code{summary(mdmr.res)} produces a data frame comprised of:
\item{Statistic}{Value of the corresponding MDMR test statistic}
\item{p-value}{The p-value for each effect.}
In addition to the information in the three columns comprising
\code{summary(res)}, the \code{res} object also contains:

\item{p.prec}{A data.frame reporting the precision of each p-value. If
analytic p-values were computed, these are the maximum error bound of the
p-values reported by the \code{davies} function in \code{CompQuadForm}. If
permutation p-values were computed, it is the standard error of each
permutation p-value.}

Note that the printed output of \code{summary(res)} will truncate p-values
to the smallest trustworthy values, but the object returned by
\code{summary(res)} will contain the p-values as computed. The reason for
this truncation differs for analytic and permutation p-values. For an
analytic p-value, if the error bound of the Davies algorithm is larger than
the p-value, the only conclusion that can be drawn with certainty is that
the p-value is smaller than (or equal to) the error bound.
}
\description{
\code{summary} method for class \code{mixed.mdmr}
}
\examples{
data("clustmdmrdata")

# Get distance matrix
D <- dist(Y.clust)

# Regular MDMR without the grouping variable
mdmr.res <- mdmr(X = X.clust[,1:2], D = D, perm.p = FALSE)

# Results look significant
summary(mdmr.res)


# Account for grouping variable
mixed.res <- mixed.mdmr(~ x1 + x2 + (x1 + x2 | grp),
                        data = X.clust, D = D)

# Signifance was due to the grouping variable
summary(mixed.res)

}
\author{
Daniel B. McArtor (dmcartor@nd.edu) [aut, cre]
}
\references{
Davies, R. B. (1980). The Distribution of a Linear Combination of
 chi-square Random Variables. Journal of the Royal Statistical Society.
 Series C (Applied Statistics), 29(3), 323-333.

 Duchesne, P., & De Micheaux, P. L. (2010). Computing the distribution of
 quadratic forms: Further comparisons between the Liu-Tang-Zhang
 approximation and exact methods. Computational Statistics and Data
 Analysis, 54(4), 858-862.

 McArtor, D. B. (2017). Extending a distance-based approach to multivariate
 multiple regression (Doctoral Dissertation).

 McArtor, D. B. & Lubke, G. H. (in preparation). Multivariate distance matrix
 regression with hierarchically clustered samples.
}

