% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/information_gain.R
\name{ComputeMaxInfoGains}
\alias{ComputeMaxInfoGains}
\title{Max information gains}
\usage{
ComputeMaxInfoGains(data, decision, dimensions = 1, divisions = NULL,
  discretizations = 1, seed = NULL, range = NULL, pseudo.count = 0.25,
  return.tuples = FALSE, interesting.vars = c(), use.CUDA = FALSE)
}
\arguments{
\item{data}{input data where columns are variables and rows are observations (all numeric)}

\item{decision}{decision variable as a binary sequence of length equal to number of observations}

\item{dimensions}{number of dimensions (a positive integer; on CUDA limited to 2--5 range)}

\item{divisions}{number of divisions (from 1 to 15; additionally limited by dimensions if using CUDA; \code{NULL} selects probable optimal number)}

\item{discretizations}{number of discretizations}

\item{seed}{seed for PRNG used during discretizations (\code{NULL} for random)}

\item{range}{discretization range (from 0.0 to 1.0; \code{NULL} selects probable optimal number)}

\item{pseudo.count}{pseudo count}

\item{return.tuples}{whether to return tuples where max IG was observed (one tuple per variable) - not supported with CUDA and in 1D}

\item{interesting.vars}{limit examined tuples to only those containing all specified variables (default: do not limit) - not supported with CUDA}

\item{use.CUDA}{whether to use CUDA acceleration (must be compiled with CUDA)}
}
\value{
A \code{\link{data.frame}} with the following columns:
 \itemize{
   \item \code{IG} -- max information gain (of each variable)
   \item \code{Tuple.1, Tuple.2, ...} -- corresponding tuple (up to \code{dimensions} columns, available only when \code{return.tuples == T} and \code{dimensions > 1})
 }

 Additionally attribute named \code{run.params} with run parameters is set on the result.
}
\description{
Max information gains
}
\examples{
\donttest{
ComputeMaxInfoGains(madelon$data, madelon$decision, dimensions = 2, divisions = 1,
                    range = 0, seed = 0)
}
}
