% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dose.functions.R
\name{demax}
\alias{demax}
\title{Emax dose-response function}
\usage{
demax(emax = "rel", ed50 = "rel", hill = NULL, p.expon = FALSE)
}
\arguments{
\item{emax}{Pooling for Emax  parameter. Can take \code{"rel"}, \code{"common"}, \code{"random"} or be
assigned a numeric value (see details).}

\item{ed50}{Pooling for ED50 parameter. Can take \code{"rel"}, \code{"common"}, \code{"random"} or be
assigned a numeric value (see details).}

\item{hill}{Pooling for Hill parameter. Can take \code{"rel"}, \code{"common"}, \code{"random"} or be
assigned a numeric value (see details).}

\item{p.expon}{A logical object to indicate whether \code{ed50} and \code{hill} parameters should be
expressed within the dose-response function on an exponential scale}
}
\value{
An object of \code{class("dosefun")}
}
\description{
Emax dose-response function
}
\details{
Emax represents the maximum response.
exp(ED50) represents the dose at which 50\% of the maximum response is achieved.
exp(Hill) is the Hill parameter, which allows for a sigmoidal function.

Without Hill parameter:
\deqn{\frac{E_{max}\times{x}}{ET_{50}+x}}

With Hill parameter:
\deqn{\frac{E_{max}\times{x^{hill}}}{ET_{50}\times{hill}}+x^{hill}}
}
\section{Dose-response parameters}{
\tabular{ll}{
   \strong{Argument} \tab \strong{Model specification} \cr
   \code{"rel"} \tab Implies that \emph{relative} effects should be pooled for this dose-response parameter separately for each agent in the network. \cr
   \code{"common"} \tab Implies that all agents share the same common effect for this dose-response parameter. \cr
   \code{"random"} \tab Implies that all agents share a similar (exchangeable) effect for this dose-response parameter. This approach allows for modelling of variability between agents. \cr
   \code{numeric()} \tab Assigned a numeric value, indicating that this dose-response parameter should not be estimated from the data but should be assigned the numeric value determined by the user. This can be useful for fixing specific dose-response parameters (e.g. Hill parameters in Emax functions) to a single value. \cr
}


When relative effects are modelled on more than one dose-response parameter,
correlation between them is automatically estimated using a vague inverse-Wishart prior.
This prior can be made slightly more informative by specifying the scale matrix \code{omega}
and by changing the degrees of freedom of the inverse-Wishart prior
using the \code{priors} argument in \code{mbnma.run()}.
}

\examples{
# Model without a Hill parameter
demax(emax="rel", ed50="common")

# Model including a Hill parameter and defaults for Emax and ED50 parameters
demax(hill="common")

}
\references{
\insertAllCited
}
