% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{HF2PPITT}
\alias{HF2PPITT}
\title{Studies of triptans for headache pain relief}
\format{A data frame in long format (one row per arm and study), with with 181 rows and 6 variables:
\itemize{
\item \code{studyID} Study identifiers
\item \code{AuthorYear} The author and year published of the study
\item \code{N} Numeric data indicating the number of participants in a study arm
\item \code{r} Numeric data indicating the number of responders (headache free at 2 hours) in a study arm
\item \code{dose} Numeric data indicating the standardised dose received
\item \code{agent} Factor data indicating the agent to which participants were randomised
}}
\source{
\insertAllCited{}
}
\usage{
HF2PPITT
}
\description{
A dataset from a systematic review of interventions for pain relief in migraine \insertCite{thorlund2014}{MBNMAdose}.
The outcome is binary, and represents (as aggregate data) the proportion of participants who were
headache-free at 2 hours. Data are from patients who had had at least one migraine attack, who were
not lost to follow-up, and who did not violate the trial protocol. The dataset includes 70 Randomised-Controlled
Trials (RCTs), comparing 7 triptans with placebo. Doses are standardised as relative to a "common" dose,
and in total there are 23 different treatments (combination of dose and agent).
}
\keyword{datasets}
