% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/Script_DROPLET_07_ADHOC_PLOT_PCA_2_PlotValues_PSI.R
\name{PlotValues.PCA.PSI.10x}
\alias{PlotValues.PCA.PSI.10x}
\title{Annotate reduced dimension space with PSI values}
\usage{
PlotValues.PCA.PSI.10x(
  MarvelObject,
  cell.ids = NULL,
  coord.intron,
  min.gene.count = 3,
  point.size = 0.1,
  log2.transform = FALSE,
  color.gradient = c("grey90", "blue", "red"),
  type
)
}
\arguments{
\item{MarvelObject}{Marvel object. S3 object generated from \code{CheckAlignment.10x} function.}

\item{cell.ids}{Vector of character strings. Specific set of cells to plot.}

\item{coord.intron}{Character string. Coordinates of splice junction whose expression will be plotted.}

\item{min.gene.count}{Numeric value. Minimum raw gene count, above which, the PSI value will be calculate for the cell. Default is \code{3}.}

\item{point.size}{Numeric value. Size of data points. Default is \code{1}.}

\item{log2.transform}{Logical value. If set to \code{TRUE}, PSI values will be log2-transformed. Useful for highlighting small changes in PSI values between cell groups. Default is \code{FALSE}.}

\item{color.gradient}{Vector of character strings. Colors to indicate low, moderate, and high expression. Default is \code{c("grey90","blue","red")}.}

\item{type}{Character string. Type of reduced dimension space. Options are \code{"umap"} and \code{"tsne"}.}
}
\value{
An object of class S3 with new slot \code{MarvelObject$adhocPlot$PCA$PSI}.
}
\description{
Annotates reduced dimension space, e.g., UMAP and tSNE, with PSI values.
}
\examples{

marvel.demo.10x <- readRDS(system.file("extdata/data",
                               "marvel.demo.10x.rds",
                               package="MARVEL")
                               )

# Define cell groups
    # Retrieve sample metadata
    sample.metadata <- marvel.demo.10x$sample.metadata

    # iPSC
    index <- which(sample.metadata$cell.type=="iPSC")
    cell.ids.1 <- sample.metadata[index, "cell.id"]
    length(cell.ids.1)

    # Cardio day 10
    index <- which(sample.metadata$cell.type=="Cardio day 10")
    cell.ids.2 <- sample.metadata[index, "cell.id"]
    length(cell.ids.2)

    # Save into list
    cell.group.list <- list("iPSC"=cell.ids.1,
                            "Cardio d10"=cell.ids.2
                            )

# Plot expression
marvel.demo.10x <- PlotValues.PCA.PSI.10x(
                        MarvelObject=marvel.demo.10x,
                        coord.intron="chr1:23693914:23694659",
                        min.gene.count=3,
                        log2.transform=FALSE,
                        color.gradient=c("grey","cyan","green","yellow","red"),
                        type="tsne"
                        )

# Check output
marvel.demo.10x$adhocPlot$PCA$PSI
}
