% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/Script_PLATE_03_PREPROCESS_3_1_CheckAlignment_PSI.R
\name{CheckAlignment.PSI}
\alias{CheckAlignment.PSI}
\title{Check Alignment for splicing data}
\usage{
CheckAlignment.PSI(MarvelObject)
}
\arguments{
\item{MarvelObject}{S3 object generated from \code{CreateMarvelObject} or \code{SubsetSamples} function.}
}
\value{
An object of class S3. The original \code{MarvelObject$SplicePheno}, \code{MarvelObject$SpliceFeature}, and \code{MarvelObject$PSI} are updated
}
\description{
\code{CheckAlignment} checks if the metadata aligns with the columns and rows of the matrix for splicing data.
}
\details{
This function checks if the \code{sample.id} column of \code{MarvelObject$SplicePheno} aligns with the column names of matrix in \code{MarvelObject$PSI}. To do this, the function subset overlapping sample IDs present in both the phenoData and matrix. This function also checks if the \code{tran_id} column of the \code{MarvelObject$SpliceFeature} aligns with the \code{tran_id} column of matrix in \code{MarvelObject$PSI}. To do this, the function subset overlappign gene IDs present in both the featureData and matrix.
}
\examples{
# Load input
marvel <- readRDS(system.file("extdata/Data", "MarvelObject.rds", package="MARVEL"))

# Run example
marvel <- CheckAlignment.PSI(MarvelObject=marvel)
}
\author{
Sean Wen <sean.wenwx@gmail.com>
}
