% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RASTtogbk.R
\name{RASTtogbk}
\alias{RASTtogbk}
\title{Write RAST files to Genbank formats OrthoMCL Analysis}
\usage{
RASTtogbk(input_fasta, input_reference, out_name_path)
}
\arguments{
\item{input_fasta}{path to input fasta file}

\item{input_reference}{path to a .csv file; it should be downloaded from RAST as excel format, saved as a .csv (saved as the tab-delimited version has compatibility problems)}

\item{out_name_path}{name and path of the file to write to}
}
\description{
Useful for reformating RAST files to GBK format
}
\examples{

lfrc_fasta <- system.file('extdata', 'RASTtogbk//lfrc.fasta', package='MAGNAMWAR')
lfrc_reference <- system.file('extdata', 'RASTtogbk//lfrc_lookup.csv', package='MAGNAMWAR')
lfrc_path <- system.file('extdata', 'RASTtogbk//lfrc_out.fasta', package='MAGNAMWAR')

RASTtogbk(lfrc_fasta,lfrc_reference,lfrc_path)


}
