% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateMutationTypePlot.R
\name{generateMutationTypePlot}
\alias{generateMutationTypePlot}
\title{Function to generate silent and non-silent mutation plot}
\usage{
generateMutationTypePlot(mymaf, savename = NULL, returndata = FALSE)
}
\arguments{
\item{mymaf}{The MAF object}

\item{savename}{The name and path of the output file}

\item{returndata}{Flag to output the plot data (By Default
returndata = FALSE)}
}
\value{
A ggplot object if returndata is FALSE or a list
containing the ggplot object and plot data if returndata
is TRUE
}
\description{
This function generates silent and non-silent
mutation plot using the MAF data.
}
\examples{
library(MAFDash)
library(maftools)
maf <- system.file("extdata", "test.mutect2.maf.gz", package = "MAFDash")
generateMutationTypePlot(read.maf(maf))
}
\author{
Mayank Tandon, Ashish Jain
}
