% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_CW2pLM.R
\name{convert_CW2pLM}
\alias{convert_CW2pLM}
\alias{CW2pLM}
\title{Transform a CW-OSL curve into a pLM-OSL curve}
\usage{
convert_CW2pLM(values)

CW2pLM(values)
}
\arguments{
\item{values}{\linkS4class{RLum.Data.Curve} or \link{data.frame} (\strong{required}):
\code{RLum.Data.Curve} data object. Alternatively, a \code{data.frame} of the measured
curve data of type stimulation time (t) (\code{values[,1]}) and measured counts (cts)
(\code{values[,2]}) can be provided.}
}
\value{
The function returns the same data type as the input data type with
the transformed curve values (\link{data.frame} or \linkS4class{RLum.Data.Curve}).
}
\description{
Transforms a conventionally measured continuous-wave (CW) curve into a
pseudo linearly modulated (pLM) curve using the equations given in Bulur
(2000).
}
\details{
According to Bulur (2000) the curve data are transformed by introducing two
new parameters \code{P} (stimulation period) and \code{u} (transformed time):

\deqn{P=2*max(t)} \deqn{u=\sqrt{(2*t*P)}}

The new count values are then calculated by
\deqn{ctsNEW = cts(u/P)}

and the returned \code{data.frame} is produced by: \code{data.frame(u,ctsNEW)}

The output of the function can be further used for LM-OSL fitting.
}
\note{
The transformation is recommended for curves recorded with a channel
resolution of at least 0.05 s/channel.
}
\section{Function version}{
 0.4.2
}

\examples{

##read curve from CWOSL.SAR.Data transform curve and plot values
data(ExampleData.BINfileData, envir = environment())

##read id for the 1st OSL curve
id.OSL <- CWOSL.SAR.Data@METADATA[CWOSL.SAR.Data@METADATA[,"LTYPE"] == "OSL","ID"]

##produce x and y (time and count data for the data set)
x<-seq(CWOSL.SAR.Data@METADATA[id.OSL[1],"HIGH"]/CWOSL.SAR.Data@METADATA[id.OSL[1],"NPOINTS"],
       CWOSL.SAR.Data@METADATA[id.OSL[1],"HIGH"],
       by = CWOSL.SAR.Data@METADATA[id.OSL[1],"HIGH"]/CWOSL.SAR.Data@METADATA[id.OSL[1],"NPOINTS"])
y <- unlist(CWOSL.SAR.Data@DATA[id.OSL[1]])
values <- data.frame(x,y)

##transform values
values.transformed <- convert_CW2pLM(values)

##plot
plot(values.transformed)

} 

\section{How to cite}{
Kreutzer, S., 2025. convert_CW2pLM(): Transform a CW-OSL curve into a pLM-OSL curve. Function version 0.4.2. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.1.0. https://r-lum.github.io/Luminescence/
}

\references{
Bulur, E., 2000. A simple transformation for converting CW-OSL
curves to LM-OSL curves. Radiation Measurements, 32, 141-145.

\strong{Further Reading}

Bulur, E., 1996. An Alternative Technique For Optically Stimulated
Luminescence (OSL) Experiment. Radiation Measurements, 26, 701-709.
}
\seealso{
\link{CW2pHMi}, \link{CW2pLMi}, \link{CW2pPMi}, \link{fit_LMCurve}, \link{lm},
\linkS4class{RLum.Data.Curve}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team}
\keyword{manip}
