test_that("Test general import", {
  testthat::skip_on_cran()
  local_edition(3)

  ## BINX
  expect_type(
    object = import_Data(system.file("extdata/BINfile_V8.binx", package = "Luminescence")),
    type = "list")

  ## XSYG
  expect_type(
    object = import_Data(system.file("extdata/XSYG_file.xsyg", package = "Luminescence")),
    type = "list")

  ## PSL
  expect_s4_class(
    object = import_Data(system.file("extdata/DorNie_0016.psl", package = "Luminescence")),
    class = "RLum.Analysis")

  ## DAT (Daybreak)
  expect_type(
    object = import_Data(system.file("extdata/Daybreak_TestFile.DAT", package = "Luminescence")),
    type = "list")

  ## TXT (Daybreak)
  expect_type(
    object = import_Data(system.file("extdata/Daybreak_TestFile.txt", package = "Luminescence")),
    type = "list")

  ## RF
  expect_type(
    object = import_Data(system.file("extdata/RF_file.rf", package = "Luminescence")),
    type = "list")

  ## TIFF
  expect_s4_class(
    object = import_Data(system.file("extdata/TIFFfile.tif", package = "Luminescence")),
    class = "RLum.Data.Image")

})
