% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_FilterCombinations.R
\name{plot_FilterCombinations}
\alias{plot_FilterCombinations}
\title{Plot filter combinations along with the (optional) net transmission window}
\usage{
plot_FilterCombinations(
  filters,
  wavelength_range = 200:1000,
  show_net_transmission = TRUE,
  interactive = FALSE,
  plot = TRUE,
  ...
)
}
\arguments{
\item{filters}{\link{list} (\strong{required}):
a named list of filter data for each filter to be shown.
The filter data itself should be either provided as \link{data.frame} or \link{matrix}.
(for more options s. Details)}

\item{wavelength_range}{\link{numeric} (\emph{with default}):
wavelength range used for the interpolation}

\item{show_net_transmission}{\link{logical} (\emph{with default}):
show net transmission window as polygon.}

\item{interactive}{\link{logical} (\emph{with default}):
enable/disable interactive plot}

\item{plot}{\link{logical} (\emph{with default}):
enables or disables the plot output}

\item{...}{further arguments that can be passed to control the plot output.
Supported are \code{main}, \code{xlab}, \code{ylab}, \code{xlim}, \code{ylim}, \code{type}, \code{lty}, \code{lwd}.
For non common plotting parameters see the details section.}
}
\value{
Returns an S4 object of type \linkS4class{RLum.Results}.

\strong{@data}

\tabular{lll}{
\strong{\code{Object}} \tab \strong{\code{Type}} \strong{\code{Description}} \cr
\code{net_transmission_window} \tab \code{matrix} \tab the resulting net transmission window \cr
\code{OD_total} \tab \code{matrix} \tab the total optical density\cr
\code{filter_matrix} \tab \code{matrix} \tab the filter matrix used for plotting
}

\strong{@info}

\tabular{lll}{
\strong{Object} \tab \strong{Type} \strong{Description} \cr
\code{call} \tab \link{call} \tab the original function call
}
}
\description{
The function allows to plot transmission windows for different filters. Missing data for specific
wavelengths are automatically interpolated for the given filter data using the function \link{approx}.
With that a standardised output is reached and a net transmission window can be shown.
}
\details{
\strong{Calculations}

\strong{Net transmission window}

The net transmission window of two filters is approximated by

\deqn{T_{final} = T_{1} * T_{2}}

\strong{Optical density}

\deqn{OD = -log10(T)}

\strong{Total optical density}

\deqn{OD_{total} = OD_{1} +  OD_{2}}

Please consider using own calculations for more precise values.

\strong{How to provide input data?}

\emph{CASE 1}

The function expects that all filter values are either of type \code{matrix} or \code{data.frame}
with two columns. The first columns contains the wavelength, the second the relative transmission
(but not in percentage, i.e. the maximum transmission can be only become 1).

In this case only the transmission window is show as provided. Changes in filter thickness and
reflection factor are not considered.

\emph{CASE 2}

The filter data itself are provided as list element containing a \code{matrix} or
\code{data.frame} and additional information on the thickness of the filter, e.g.,
\code{list(filter1 = list(filter_matrix, d = 2))}.
The given filter data are always considered as standard input and the filter thickness value
is taken into account by

\deqn{Transmission = Transmission^(d)}

with d given in the same dimension as the original filter data.

\emph{CASE 3}

Same as CASE 2 but additionally a reflection factor P is provided, e.g.,
\code{list(filter1 = list(filter_matrix, d = 2, P = 0.9))}.
The final transmission becomes:

\deqn{Transmission = Transmission^(d) * P}

\strong{Advanced plotting parameters}

The following further non-common plotting parameters can be passed to the function:

\tabular{lll}{
\strong{\code{Argument}} \tab \strong{\code{Datatype}} \tab \strong{\code{Description}}\cr
\code{legend} \tab \code{logical} \tab enable/disable legend \cr
\code{legend.pos} \tab \code{character} \tab change legend position (\link[graphics:legend]{graphics::legend}) \cr
\code{legend.text} \tab \code{character} \tab same as the argument \code{legend} in (\link[graphics:legend]{graphics::legend}) \cr
\code{net_transmission.col} \tab \code{col} \tab colour of net transmission window polygon \cr
\code{net_transmission.col_lines} \tab \code{col} \tab colour of net transmission window polygon lines \cr
\code{net_transmission.density} \tab  \code{numeric} \tab specify line density in the transmission polygon \cr
\code{grid} \tab \code{list} \tab full list of arguments that can be passed to the function \link[graphics:grid]{graphics::grid}
}

For further modifications standard additional R plot functions are recommend, e.g., the legend
can be fully customised by disabling the standard legend and use the function \link[graphics:legend]{graphics::legend}
instead.
}
\section{Function version}{
 0.3.2
}

\examples{

## (For legal reasons no real filter data are provided)

## Create filter sets
filter1 <- density(rnorm(100, mean = 450, sd = 20))
filter1 <- matrix(c(filter1$x, filter1$y/max(filter1$y)), ncol = 2)
filter2 <- matrix(c(200:799,rep(c(0,0.8,0),each = 200)), ncol = 2)

## Example 1 (standard)
plot_FilterCombinations(filters = list(filter1, filter2))

## Example 2 (with d and P value and name for filter 2)
results <- plot_FilterCombinations(
filters = list(filter_1 = filter1, Rectangle = list(filter2, d = 2, P = 0.6)))
results

## Example 3 show optical density
plot(results$OD_total)

\dontrun{
##Example 4
##show the filters using the interactive mode
plot_FilterCombinations(filters = list(filter1, filter2), interactive = TRUE)

}


}
\seealso{
\linkS4class{RLum.Results}, \link{approx}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2024. plot_FilterCombinations(): Plot filter combinations along with the (optional) net transmission window. Function version 0.3.2. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., 2024. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.24. https://CRAN.R-project.org/package=Luminescence
}

\keyword{aplot}
\keyword{datagen}
