% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_RLum.Data.Curve.R
\name{plot_RLum.Data.Curve}
\alias{plot_RLum.Data.Curve}
\title{Plot function for an RLum.Data.Curve S4 class object}
\usage{
plot_RLum.Data.Curve(
  object,
  par.local = TRUE,
  norm = FALSE,
  smooth = FALSE,
  ...
)
}
\arguments{
\item{object}{\linkS4class{RLum.Data.Curve} (\strong{required}):
S4 object of class \code{RLum.Data.Curve}}

\item{par.local}{\link{logical} (\emph{with default}):
use local graphical parameters for plotting, e.g. the plot is shown in one
column and one row. If \code{par.local = FALSE}, global parameters are inherited.}

\item{norm}{\link{logical} \link{character} (\emph{with default}): allows curve normalisation to the
highest count value ('default'). Alternatively, the function offers the
modes \code{"max"}, \code{"min"} and \code{"huot"} for a background corrected normalisation, see details.}

\item{smooth}{\link{logical} (\emph{with default}):
provides an automatic curve smoothing based on \link[zoo:rollmean]{zoo::rollmean}}

\item{...}{further arguments and graphical parameters that will be passed
to the \code{plot} function}
}
\value{
Returns a plot.
}
\description{
The function provides a standardised plot output for curve data of an
\code{RLum.Data.Curve} S4-class object.
}
\details{
Only single curve data can be plotted with this function.Arguments
according to \link{plot}.

\strong{Curve normalisation}

The argument \code{norm} normalises all count values, to date the following
options are supported:

\code{norm = TRUE} or \code{norm = "max"}: Curve values are normalised to the highest
count value in the curve

\code{norm = "last"}: Curves values are normalised to the last count value
(this can be useful in particular for radiofluorescence curves)

\code{norm = "huot"}: Curve values are normalised as suggested by Sébastien Huot
via GitHub:
\deqn{
y = (observed - median(background)) / (max(observed) - median(background))
}

The background of the curve is defined as the last 20 \% of the count values
of a curve.
}
\note{
Not all arguments of \link{plot} will be passed!
}
\section{Function version}{
 0.2.6
}

\examples{

##plot curve data

#load Example data
data(ExampleData.CW_OSL_Curve, envir = environment())

#transform data.frame to RLum.Data.Curve object
temp <- as(ExampleData.CW_OSL_Curve, "RLum.Data.Curve")

#plot RLum.Data.Curve object
plot_RLum.Data.Curve(temp)


}
\seealso{
\link{plot}, \link{plot_RLum}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2022. plot_RLum.Data.Curve(): Plot function for an RLum.Data.Curve S4 class object. Function version 0.2.6. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., 2022. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.20. https://CRAN.R-project.org/package=Luminescence
}

\keyword{aplot}
