% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apply_EfficiencyCorrection.R
\name{apply_EfficiencyCorrection}
\alias{apply_EfficiencyCorrection}
\title{Function to apply spectral efficiency correction to RLum.Data.Spectrum S4
class objects}
\usage{
apply_EfficiencyCorrection(object, spectral.efficiency)
}
\arguments{
\item{object}{\linkS4class{RLum.Data.Spectrum} or \linkS4class{RLum.Analysis} (\strong{required}):
S4 object of class \code{RLum.Data.Spectrum},  \code{RLum.Analysis}or a \link{list} of such objects. Other objects in
the list are skipped.}

\item{spectral.efficiency}{\link{data.frame} (\strong{required}):
Data set containing wavelengths (x-column) and relative spectral response values
(y-column) (values between 0 and 1). The provided data will be used to correct all spectra if \code{object} is
a \link{list}}
}
\value{
Returns same object as provided as input
}
\description{
The function allows spectral efficiency corrections for RLum.Data.Spectrum
S4 class objects
}
\details{
The efficiency correction is based on a spectral response dataset provided
by the user. Usually the data set for the quantum efficiency is of lower
resolution and values are interpolated for the required spectral resolution using
the function \link[stats:approxfun]{stats::approx}

If the energy calibration differs for both data set \code{NA} values are produces that
will be removed from the matrix.
}
\note{
Please note that the spectral efficiency data from the camera alone may not
sufficiently correct for spectral efficiency of the entire optical system
(e.g., spectrometer, camera ...).
}
\section{Function version}{
 0.2.0
}

\examples{

##(1) - use with your own data (uncomment for usage)
## spectral.efficiency <- read.csv("your data")
##
## your.spectrum <- apply_EfficiencyCorrection(your.spectrum, )

}
\seealso{
\linkS4class{RLum.Data.Spectrum}, \linkS4class{RLum.Analysis}
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, UMR 5060, CNRS-Université Bordeaux Montaigne (France)\cr
Johannes Friedrich, University of Bayreuth (Germany)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., Friedrich, J., 2021. apply_EfficiencyCorrection(): Function to apply spectral efficiency correction to RLum.Data.Spectrum S4 class objects. Function version 0.2.0. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., 2021. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.9.11. https://CRAN.R-project.org/package=Luminescence
}

\keyword{manip}
