% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github.R
\name{GitHub-API}
\alias{GitHub-API}
\alias{github_commits}
\alias{github_branches}
\alias{github_issues}
\title{GitHub API}
\usage{
github_commits(user = "r-lum", repo = "luminescence", branch = "master",
  n = 5)

github_branches(user = "r-lum", repo = "luminescence")

github_issues(user = "r-lum", repo = "luminescence", verbose = TRUE)
}
\arguments{
\item{user}{\code{\link{character}}: 
GitHub user name (defaults to 'r-lum').}

\item{repo}{\code{\link{character}}: 
name of a GitHub repository (defaults to 'luminescence').}

\item{branch}{\code{\link{character}}: 
branch of a GitHub repository (defaults to 'master').}

\item{n}{\code{\link{integer}}:
number of commits returned (defaults to 5).}

\item{verbose}{\code{\link{logical}}: 
print the output to the console (defaults to \code{TRUE}).}
}
\value{
\code{github_commits}: \code{\link{data.frame}} with columns:
\tabular{ll}{
 [ ,1] \tab SHA \cr
 [ ,2] \tab AUTHOR \cr
 [ ,3] \tab DATE \cr
 [ ,4] \tab MESSAGE \cr
}

\code{github_branches}: \code{\link{data.frame}} with columns:
\tabular{ll}{
 [ ,1] \tab BRANCH \cr
 [ ,2] \tab SHA \cr
 [ ,3] \tab INSTALL \cr
}

\code{github_commits}: Nested \code{\link{list}} with \code{n} elements.
Each commit element is a list with elements:
\tabular{ll}{
 [[1]] \tab NUMBER \cr
 [[2]] \tab TITLE \cr
 [[3]] \tab BODY \cr
 [[4]] \tab CREATED \cr
 [[5]] \tab UPDATED \cr
 [[6]] \tab CREATOR \cr
 [[7]] \tab URL \cr
 [[8]] \tab STATUS \cr
}
}
\description{
R Interface to the GitHub API v3.
}
\details{
These functions can be used to query a specific repository hosted on GitHub. \cr

\code{github_commits} lists the most recent \code{n} commits of a specific
branch of a repository.

\code{github_branches} can be used to list all current branches of a
repository and returns the corresponding SHA hash as well as an installation
command to install the branch in R via the 'devtools' package.

\code{github_issues} lists all open issues for a repository in valid YAML.
}
\section{Function version}{
 0.1.0
}

\examples{

\dontrun{
github_branches(user = "r-lum", repo = "luminescence")
github_issues(user = "r-lum", repo = "luminescence")
github_commits(user = "r-lum", repo = "luminescence", branch = "master", n = 10)
}

} 

\section{How to cite}{
Burow, C. (2017). GitHub-API(): GitHub API. Function version 0.1.0. In: Kreutzer, S., Dietze, M., Burow, C., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J. (2017). Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.7.4. https://CRAN.R-project.org/package=Luminescence
}

\references{
GitHub Developer API v3. \url{https://developer.github.com/v3/}, last accessed: 10/01/2017.
}
\author{
Christoph Burow, University of Cologne (Germany)
\cr R Luminescence Package Team}
