% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin_RLum.Data.R
\name{bin_RLum.Data}
\alias{bin_RLum.Data}
\title{Channel binning - method dispatchter}
\usage{
bin_RLum.Data(object, ...)
}
\arguments{
\item{object}{\code{\linkS4class{RLum.Data}} (\bold{required}): S4 object of
class \code{RLum.Data}}

\item{...}{further arguments passed to the specifc class method}
}
\value{
An object of the same type as the input object is provided
}
\description{
Function calls the object-specific bin functions for RLum.Data S4 class objects.
}
\details{
The function provides a generalised access point for specific
\code{\linkS4class{RLum.Data}} objects.\cr Depending on the input object, the
corresponding function will be selected. Allowed arguments can be found
in the documentations of the corresponding \code{\linkS4class{RLum.Data}} class.
}
\note{
Currenlty only \code{RLum.Data} objects of class \code{RLum.Data.Curve} are supported!
}
\section{Function version}{
 0.1.0 (2016-05-02 09:36:06)
}

\examples{

##load example data
data(ExampleData.CW_OSL_Curve, envir = environment())

##create RLum.Data.Curve object from this example
curve <-
  set_RLum(
      class = "RLum.Data.Curve",
      recordType = "OSL",
      data = as.matrix(ExampleData.CW_OSL_Curve)
  )

##plot data without and with 2 and 4 channel binning
plot_RLum(curve)
plot_RLum(bin_RLum.Data(curve, bin_size = 2))
plot_RLum(bin_RLum.Data(curve, bin_size = 4))

}
\seealso{
\code{\linkS4class{RLum.Data.Curve}}
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne
(France)
\cr R Luminescence Package Team} 

\section{How to cite}{
Kreutzer, S. (2017). bin_RLum.Data(): Channel binning - method dispatchter. Function version 0.1.0. In: Kreutzer, S., Dietze, M., Burow, C., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J. (2017). Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 0.7.3. https://CRAN.R-project.org/package=Luminescence
}

\keyword{utilities}
