% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RLum.Data.Curve-class.R
\docType{class}
\name{RLum.Data.Curve-class}
\alias{RLum.Data.Curve-class}
\alias{get_RLum,RLum.Data.Curve-method}
\alias{set_RLum,RLum.Data.Curve-method}
\title{Class \code{"RLum.Data.Curve"}}
\usage{
\S4method{set_RLum}{RLum.Data.Curve}(class, recordType, curveType, data, info)

\S4method{get_RLum}{RLum.Data.Curve}(object, info.object)
}
\arguments{
\item{class}{[\code{set_RLum}] \code{\link{character}} (\bold{required}): name of the \code{RLum} class to create}

\item{recordType}{[\code{set_RLum}] \code{\link{character}} (optional): record type (e.g. "OSL")}

\item{curveType}{[\code{set_RLum}] \code{\link{character}} (optional): curve type (e.g. "predefined" or "measured")}

\item{data}{[\code{set_RLum}] \code{\link{matrix}} (\bold{required}): raw curve data}

\item{info}{[\code{set_RLum}] \code{\link{list}} (optional): info elements}

\item{object}{[\code{get_RLum}] an object of class \code{\linkS4class{RLum.Data.Curve}} (\bold{required})}

\item{info.object}{[\code{get_RLum}] \code{\link{character}} (optional): name of the wanted info
element}
}
\description{
Class for luminescence curve data.
}
\section{Methods (by generic)}{
\itemize{
\item \code{set_RLum}: Construction method for RLum.Data.Curve object. The slot info is optional
and predefined as empty list by default.

\item \code{get_RLum}: Accessor method for RLum.Data.Curve object. The argument info.object is
optional to directly access the info elements. If no info element name is
provided, the raw curve data (matrix) will be returned.
}}
\section{Slots}{

\describe{
\item{\code{recordType}}{Object of class "character" containing the type of the curve (e.g. "TL" or "OSL")}

\item{\code{curveType}}{Object of class "character" containing curve type, allowed values are measured or predefined}

\item{\code{data}}{Object of class "matrix" containing curve x and y data}

\item{\code{info}}{Object of class "list" containing further meta information objects}
}}
\note{
The class should only contain data for a single curve. For additional
elements the slot \code{info} can be used (e.g. providing additional heating
ramp curve).
}
\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new("RLum.Data.Curve", ...)}.
}

\section{Class version}{
 0.2.0
}
\examples{
showClass("RLum.Data.Curve")
}
\author{
Sebastian Kreutzer, IRAMAT-CRP2A, Universite Bordeaux Montaigne (France)
}
\seealso{
\code{\linkS4class{RLum}}, \code{\linkS4class{RLum.Data}},
\code{\link{plot_RLum}}
}
\keyword{classes}

