% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_PMT.R
\name{create_PMT}
\alias{create_PMT}
\title{Function to create a PMT.}
\usage{
create_PMT(name, description, efficiency)
}
\arguments{
\item{name}{\link{character}: Name of the PMT.}

\item{description}{\link{character}: Description of the PMT.}

\item{efficiency}{\link{numeric}: efficiency of the PMT [mA/W].}
}
\value{
This function return a new PMT.
}
\description{
This function create a new PMT.
}
\examples{
# Data
name <- "example"
description <- "non realistic PMT"

wavelength <- seq(200,1000,10)

values <- dnorm(x = wavelength,mean = 300,sd = 150)
values <- values/max(values)

efficiency <- matrix(data=c(wavelength,
                            values),
                     nrow = 81,
                     ncol = 2,
                     byrow = FALSE)

#PMT
PMT <- create_PMT(name = name,
                  description = description,
                  efficiency = efficiency)

plot_PMT(PMT)

}
\author{
David Strebler, University of Cologne (Germany).
}

