# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Computes the fitness used in the GA
#' @description Computes the fitness of a candidate in the genetic algorithm displayed in function Lorenz.GA.cpp
#' @param x vector of size (p-1) giving the proposed candidate, where p is the number of covariates
#' @param Y vector of size n gathering the response, where n is the sample size
#' @param X matrix of dimension (n*p) gathering the covariates
#' @param Z vector of size n gathering iid repetitions of a U[0,1]
#' @param pi vector of size n gathering the observation weights (notice that sum(pi)=1)
#' @param tolerance A small positive number used to determine the threshold for considering two floating-point numbers as equal. This is primarily used to
#' address issues with floating-point precision when comparing values that should theoretically be identical but may differ slightly due to numerical inaccuracies.
#' @return Fitness of candidate x
#' @keywords internal
.Fitness_cpp <- function(x, Y, X, Z, pi, tolerance) {
    .Call('_LorenzRegression_Fitness_cpp', PACKAGE = 'LorenzRegression', x, Y, X, Z, pi, tolerance)
}

.Fitness_meanrank <- function(x, Y, X, pi, tolerance) {
    .Call('_LorenzRegression_Fitness_meanrank', PACKAGE = 'LorenzRegression', x, Y, X, pi, tolerance)
}

.PLR_derivative_cpp_m <- function(derz, y, ycum, y_skipped, X, pi, theta, h, gamma, kernel) {
    .Call('_LorenzRegression_PLR_derivative_cpp_m', PACKAGE = 'LorenzRegression', derz, y, ycum, y_skipped, X, pi, theta, h, gamma, kernel)
}

.PLR_derivative_cpp_zero <- function(y, ycum, X, pi, theta, h, gamma, kernel) {
    .Call('_LorenzRegression_PLR_derivative_cpp_zero', PACKAGE = 'LorenzRegression', y, ycum, X, pi, theta, h, gamma, kernel)
}

.PLR_loss_cpp_m <- function(lossz, X, y, ycum, y_skipped, pi, theta, h, gamma, kernel) {
    .Call('_LorenzRegression_PLR_loss_cpp_m', PACKAGE = 'LorenzRegression', lossz, X, y, ycum, y_skipped, pi, theta, h, gamma, kernel)
}

.PLR_loss_cpp_zero <- function(X, y, ycum, pi, h, gamma, kernel) {
    .Call('_LorenzRegression_PLR_loss_cpp_zero', PACKAGE = 'LorenzRegression', X, y, ycum, pi, h, gamma, kernel)
}

.SCAD_derivative_cpp <- function(x, lambda, a) {
    .Call('_LorenzRegression_SCAD_derivative_cpp', PACKAGE = 'LorenzRegression', x, lambda, a)
}

#' @title Computes fractional ranks
#' @description Computes the vector of fractional ranks related to a given vector
#' @param x vector of size n gathering the values for which the fractional rank should be computed
#' @param pi vector of size n gathering the observation weights (notice that sum(pi)=1)
#' @return Fractional rank related to vector x
#' @keywords internal
.frac_rank_cpp <- function(x, pi) {
    .Call('_LorenzRegression_frac_rank_cpp', PACKAGE = 'LorenzRegression', x, pi)
}

