% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLR-coef.R
\name{coef.PLR}
\alias{coef.PLR}
\title{Estimated coefficients for the Penalized Lorenz Regression}
\usage{
\method{coef}{PLR}(object, renormalize = TRUE, ...)
}
\arguments{
\item{object}{Output of a call to \code{\link{Lorenz.Reg}}, where \code{penalty!="none"}.}

\item{renormalize}{whether the coefficient vector should be re-normalized to match the representation where the first category of each categorical variable is omitted. Default value is TRUE}

\item{...}{Additional arguments}
}
\value{
If the PLR was fitted with only one selection method, the output is a vector gathering the estimated coefficients.
If several selection methods were selected, it outputs a list of vectors, where each element of the list corresponds to a different selection method.
}
\description{
\code{coef.PLR} provides the estimated coefficients for an object of class \code{PLR}.
}
\examples{
data(Data.Incomes)
PLR <- Lorenz.Reg(Income ~ ., data = Data.Incomes, penalty = "SCAD",
                  h.grid = nrow(Data.Incomes)^(-1/5.5), sel.choice = c("BIC","CV"),
                  eps = 0.01, seed.CV = 123, nfolds = 5)
coef(PLR)

}
\seealso{
\code{\link{Lorenz.Reg}}
}
