% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Filter_function.R
\name{Filter_function}
\alias{Filter_function}
\title{Filter OTU/ASV/metagenomic profile/gene profile by threshold}
\usage{
Filter_function(input, threshold, format, report = TRUE)
}
\arguments{
\item{input}{Data frame of absolute abundance of standard OTU table,with the first column of OTUID and the final column of taxonomy annotation.
If your data frame is gene table or not a standard OTU table, please manually transformed into a standard input data frame.}

\item{threshold}{threshold of filter.Relative abundance for format 1 and 4, reads number for format 2, sample size for format 3}

\item{format}{1:filter OTU/gene below overall-sample relative abundance threshold(<)

2:filter OTU/gene below overall-sample reads threshold(<)

3:filter OTU/gene reads 0 over threshold sample size(>)

4:filter OTU/gene below relative abundance threshold in each sample(<)}

\item{report}{Logical. If print report to console. Default:TRUE}
}
\value{
Dataframe of OTU/gene in format of absolute abundacne(reads) or relative abundance(\%)
}
\description{
Sequenced data of taxonomy&gene still remains some sequencing error which we needed to be wiped off before analyzing.
Here we provide function including four formats to wipe them clean.
}
\examples{
### Data frame with absolute abundance (reads)###
### And first column of OTUID and last column of taxonomy ###
data(testotu)

#### If your data frame does not contain the OTUID column or taxonomy column,
#### you can add a simulated column to fit the input format like testotu ##

### 1. Filter OTU with total relative abundance below 0.0001###
filtered_otu <- Filter_function(
  input = testotu,
  threshold = 0.0001,
  format = 1
)

### 2. Filter OTU with total reads below 20 ###
filtered_otu <- Filter_function(
  input = testotu,
  threshold = 20,
  format = 2
)

### 3. Filter OTU reads 0 over (>=) 11 samples ###
filtered_otu <- Filter_function(
  input = testotu,
  threshold = 11,
  format = 3
)

### 4. Filter OTU with relative abundance below 0.0001 in each sample ###
filtered_otu <- Filter_function(
  input = testotu,
  threshold = 0.0001,
  format = 4
)
}
\author{
Wang Ningqi
}
