% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sub_tax_summary.R
\name{sub_tax_summary}
\alias{sub_tax_summary}
\title{Subsetting tax summary objects}
\usage{
sub_tax_summary(taxobj, ..., specificnum = NULL, taxnum = NULL)
}
\arguments{
\item{taxobj}{tax summary objects computed by \code{\link{tax_summary}}.}

\item{...}{logical expression that are are defined in terms of the variables in Groupfile of tax summary objects. See details in \code{\link{subset}}.}

\item{specificnum}{specific numbers indicating samples to keep based on Groupfile of tax summary objects.}

\item{taxnum}{specific numbers indicating taxonomy to keep based on Base file}
}
\value{
Subset of tax summary objects.Same as \code{\link{tax_summary}}.
}
\description{
Subsetting tax summary objects
}
\examples{
  data("Three_group")

  # Check meta file
  print(Three_group$Groupfile)

  # Subsetting tax summary objects

  # Select BF and OF groups
  sub_testtax_summary <- sub_tax_summary(Three_group, Group \%in\% c("BF", "OF"))
  print(sub_testtax_summary$Groupfile)

  # Subsetting according to taxonomy

  Proteo <- sub_tax_summary(
    Three_group,
    taxnum = which(Three_group$Base_taxonomy$Phylum == "p__Proteobacteria")
  )
  print(Proteo$Phylum_percent)  # Check phylum table
  print(Proteo$Genus_percent)   # Check genus table
}
\author{
Wang Ningqi \href{mailto:2434066068@qq.com}{2434066068@qq.com}
}
